package cn.smarthse.modules.health.vo.base.company.govern;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.health.entity.base.company.govern.CompanyGovern;
import cn.smarthse.modules.health.enums.company.govern.CompanyGovernReformStatusEnum;
import cn.smarthse.modules.health.enums.home.govern.CompanyGovernRiskTypeEnum;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Transient;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
 * @since 2022/2/23-15:34
 */
@Data
public class CompanyGovernVo extends CompanyGovern {


    private String companyName;

    private String locationAddress;

    private Long areaId;


    private String provinceName;

    private String cityName;

    private String areaName;

    private String streetName;

    private String areaFullName;

    private Integer grade;
    private String gradeName;
    /**
     * 职业健康管理状况等级
     */
    private Integer judgeLevel;
    private String judgeLevelName;
    /**
     *
     */
    private Integer riskType;
    private String riskTypeName;


    /**
     * 职业病危害暴露风险等级
     */
    private Integer riskLevel;
    private String riskLevelName;
    /**
     * 职业病危害综合风险类别
     */
    private Integer riskClassify;
    private String riskClassifyName;
    /**
     * 企业职业病危害风险类别
     */
    private Integer occType;
    private String occTypeName;


    private String reformStatusName;

    private String requireFinishTimeStr;
    /**
     * 实际完成时间：
     */
    private String actualFinishTimeStr;
    /**
     * 未评定类型
     */
    private String noEvaluateType;


    public String getCompanyName() {
        return companyName;
    }

    public String getAreaFullName() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank(provinceName)) {
            sb.append(provinceName);
        }
        if (StringUtils.isNotBlank(cityName)) {
            sb.append(cityName);
        }
        if (StringUtils.isNotBlank(areaName)) {
            sb.append(areaName);
        }
        if (StringUtils.isNotBlank(streetName)) {
            sb.append(streetName);
        }
        return sb.toString();
    }

    public String getJudgeLevelName() {
        if (judgeLevel != null) {
            return JudgeResultLevelEnum.getNameByCode(judgeLevel);
        }
        return "未评定";
    }

    public String getRiskTypeName() {
        if (riskType != null) {
            return CompanyGovernRiskTypeEnum.getName(riskType);
        }
        return "";
    }

    public String getRiskLevelName() {
        if (riskLevel != null) {
            return HazardsExposureRiskLevelEnum.getNameByCode(riskLevel);
        }
        return "未评定";
    }

    public String getRiskClassifyName() {
        if (riskClassify != null) {
            return CompanyGradeEnum.getName(riskClassify.byteValue());
        }
        return "未评定";
    }

    public String getOccTypeName() {
        if (occType != null) {
            return CompanyOccTypeEnum.getName(occType);
        }
        return "未划分";
    }

    public String getReformStatusName() {
        if (this.getReformStatus() != null) {
            return CompanyGovernReformStatusEnum.getName(this.getReformStatus().byteValue());
        }
        return "";
    }

    public String getRequireFinishTimeStr() {
        if (this.getRequireFinishTime() != null) {
            return DateUtils.formatDate(this.getRequireFinishTime());
        }
        return "";
    }

    public String getActualFinishTimeStr() {
        if (this.getActualFinishTime() != null) {
            return DateUtils.formatDate(this.getActualFinishTime());
        }
        return "";
    }

    public String getNoEvaluateType() {
        Integer riskLevel = this.getRiskLevel();
        Integer judgeLevel = this.getJudgeLevel();
        Integer o = new Integer(0);
        if (o.equals(riskLevel) && o.equals(judgeLevel)) {
            return "未评估及自查";
        } else if (o.equals(riskLevel)) {
            return "未评估";
        }else if (o.equals(riskLevel)) {
            return "未自查";
        }
        return "";
    }

    public String getGradeName() {
        if (this.getGrade() != null) {
            return CompanyGradeEnum.getName(this.getGrade().byteValue());
        }
        return "";
    }
}
