package cn.smarthse.modules.health.vo.base.company;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 区域存在的危害因素
 * @since 2020/2/26 0026 14:12
 */
@Data
public class HarmFactoCheckResultVo implements Serializable {
    private Long id; //危害因素id
    private Integer targetId;//指标id
    private String checkResult; //检测结果
    private String unit;// 单位
    
    /**
     * 检测名称
     */
    private String checkName;
    // 显示 名称
    private String showCheckName;


    // "值类型1：准确值 2：范围"
    private Integer checkValueType;

    //@ApiModelProperty(value = "指标的值（准确值）(结果是准确的值时，该字段有效，结果的类型查看当前指标对应的值类型)")
    private String checkValue;


    // @ApiModelProperty(value = "结果是范围时，范围类型：1:-，2:< ，3:<=")
    private Integer checkValueRangeType;

    // @ApiModelProperty(value = "指标的值（范围下限）")
    private String checkValueMin;

    //@ApiModelProperty(value = "指标的值（范围上限）")
    private String checkValueMax;
}