package cn.smarthse.modules.health.vo.base.company;

import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 区域存在的危害因素
 * @since 2020/2/26 0026 14:12
 */
@Data
public class AreaHarmFactorVo implements Serializable, Cloneable {
    private Long id; //危害因素id
    private Long checkId;//检测id
    private String name;// 危害因素名称
    private Date checkDate;// 检测时间
    private String decision;//结果判定
    private Long areaId;// 区域id
    private Long resultNo;//结果集编号
    private String areaPathName;// 区域名称（层级结构）
    private String hazardSource; // 来源(采样点)
    
    /**
     *  危害因素以及检测结果（有多个检测结果，则有这个几个结果的危害因素id相同）
     */
    private   List<HarmFactoCheckResultVo>  checkResulVos;

    private String sortNo; // 排序字段 （用于对列表进行排序）

    /**
     * 生成排序字段的值（按照有数据的，然后按场所的顺序进行排序，接着是没数据的，也按照场所的顺序进行排序）
     * @param allAreas
     */
    public String createSortNo(List<CompanyArea> allAreas){
        StringBuilder sb  = new StringBuilder();
        if(checkId == null || checkResulVos == null || checkResulVos.isEmpty()){
            sb.append("1-"); // 没数据放后面
        }else {
            sb.append("0-"); // 有数据放前面
        }
        this.sortNo =  sb.append(CompanyArea.creteAreaSortNo(allAreas, this.areaId)).append(+id).toString();

        return sortNo;
    }

    @Override
    public AreaHarmFactorVo clone() {
        AreaHarmFactorVo vo = new AreaHarmFactorVo();
        vo.setAreaId(this.areaId);
        vo.setAreaPathName(this.areaPathName);
        vo.setCheckDate(this.checkDate);
        vo.setCheckId(this.checkId);
        vo.setName(this.name);
        vo.setId(this.id);
        vo.setDecision(this.decision);
        vo.setResultNo(this.resultNo);
        vo.setHazardSource(this.hazardSource);
        vo.setSortNo(this.sortNo);
        vo.setCheckResulVos(this.checkResulVos);
        return vo;
    }
}