package cn.smarthse.modules.health.vo.base.company;

import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/3/25 下午6:47
 * @description 危害因素检测结果 一个危害因数可能检测多次有多个结果
 */
@Data
public class AreaHarmFactorCheckVo implements Serializable {

    private Long id; //危害因素id
    private String name;// 危害因素名称
    private Long areaId;// 区域id
    private String areaPathName;// 区域名称（层级结构）

    private List<AreaHarmCheckVo> checkResults = new ArrayList<>(); // 检测结果

    @Data
    public static class AreaHarmCheckVo{
        private Long checkId;//检测id
        private Date checkDate;// 检测时间
        private String decision;//结果判定

        private List<ItemCheckResult> itemCheckResults; // 每一项的检测结果

    }

    @Data
    public static class ItemCheckResult{
        private String unit;// 单位
        private String keyName;//检测项目 如cmac,cstel...
        private String checkResult; //检测结果
    }
    private String sortNo; // 排序字段 （用于对列表进行排序）

    /**
     * 生成排序字段的值（按照有数据的，然后按场所的顺序进行排序，接着是没数据的，也按照场所的顺序进行排序）
     * @param allAreas
     */
    public String createSortNo(List<CompanyArea> allAreas){
        StringBuilder sb  = new StringBuilder();
        if(checkResults.isEmpty()){
            sb.append("1-"); // 没数据放后面
        }else {
            sb.append("0-"); // 有数据放前面
        }
        this.sortNo =  sb.append(CompanyArea.creteAreaSortNo(allAreas, this.areaId)).toString();
        return sortNo;
    }


}

