package cn.smarthse.modules.health.vo.base;

import java.io.Serializable;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 部门防护设备维护数
 * @since 2019/10/15 0015 15:18
 */
public class DeptDeviceMaintainNum implements Serializable {

    private String deptId; // 部门id
    private String deptName; //部门名称
    private Integer deviceNum;//应该维护的防护设备数
    private Integer maintainDeviceNum;//已维护防护设备数

    private Double maintainRate; //维护率

    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Integer getDeviceNum() {
        return deviceNum;
    }

    public void setDeviceNum(Integer deviceNum) {
        this.deviceNum = deviceNum;
    }

    public Integer getMaintainDeviceNum() {
        return maintainDeviceNum;
    }

    public void setMaintainDeviceNum(Integer maintainDeviceNum) {
        this.maintainDeviceNum = maintainDeviceNum;
    }

    public Double getMaintainRate() {
        return maintainDeviceNum.doubleValue() / deviceNum.doubleValue();
    }

    public void setMaintainRate(Double maintainRate) {
        this.maintainRate = maintainRate;
    }
}
