package cn.smarthse.modules.health.vo.archive;

import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

public @Data class WorkRoleHarmFactorShieldEquipVO implements Serializable{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 岗位危害因素信息
     */
    private HarmfactorWork  harmFactorWork;

    /**
     * 岗位总人数
     */
    private Integer workRoleUserCount;

    /**
     * 岗位女工数量
     */
    private Integer workRoleFemaleCount;

    /**
     * 危害因素名称
     */
    private String harmFactorNames;

    /**
     * 危害因素来源
     */
    private String harmFactorSource;

    /**
     * 岗位发放的个人防护用品
     */
    private List<ShieldWorkRelation> shieldList;

    /**
     * 岗位中使用的设备（类型为：职业病防护设施）
     */
    private List<DeviceListView> deviceList;

    /**
     * 工程防护措施
     */
    private String deviceName;

    private String workName;

}
