package cn.smarthse.modules.health.vo.archive;

import java.util.ArrayList;
import java.util.List;

public enum ResultCollectType {
	
	/**
	 * 化学物质 
	 */
	 CHEMICAL(1,"化学物质 ",false,1,"colellectchemical","colellectchemicaltr","colellectchemicaledit",
			 "colellectchemicalstaff"
			 ,null,LimitValueTable.l_08_2_occupational_risk_factors_hx_sw),
	 /**
	  * 粉尘
	  */
	 DUST(2,"粉尘",false,1,"colellectdust","colellectdusttr","colellectdustedit" 
			 ,"colellectduststaff"
			 ,null,LimitValueTable.l_08_3_occupational_risk_factors_fc),
	 /**
	  * 生物因素
	  */
	 BIOLOGICAL(3,"生物因素",false,1,"colellectbiological","colellectbiologicaltr","colellectbiologicaledit"
			 ,"colellectbiologicalstaff"
			 ,null,LimitValueTable.l_08_2_occupational_risk_factors_hx_sw),
	 /**
	  * 噪声 
	  */
	 NOISE(4,"噪声 ",false,2,"collectnoise","collectnoisetr","collectnoiseedit"
			 ,"collectnoisestaff"
			 ,"WL1",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 高频电磁场
	  */
	 HIGHFREQUENCY(5,"高频电磁场",false,2,"collecthighfrequency","collecthighfrequencytr","collecthighfrequencyedit"
			 ,"collecthighfrequencystaff"
			 ,"WL13",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 电离辐射
	  */
	 IONIZINGRADIATION(6,"电离辐射",false,2,"collectionizingradiation","collectionizingradiationtr","collectionizingradiationedit"
			 ,"collectionizingradiationstaff"
			 ,null,LimitValueTable.L_08_4_occupational_risk_factors_fs),
	 /**
	  * 超高频辐射 
	  */
	 ULTRAHIGHFREQUENCYRADIATION(7,"超高频辐射 ",false,2,"collectultrahighfrequencyradiation","collectultrahighfrequencyradiationtr","collectultrahighfrequencyradiationedit"
			 ,"collectultrahighfrequencyradiationstaff"
			 ,"WL14",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 手传振动
	  */
	 HANDTRANSMITTED(8,"手传振动",false,2,"collecthandtransmitted","collecthandtransmittedtr","collecthandtransmittededit"
			 ,"collecthandtransmittedstaff"
			 ,"WL6",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 微波辐射
	  */
	 MICROWAVERADIATION (9,"微波辐射",false,2,"collectmicrowaveradiation","collectmicrowaveradiationtr","collectmicrowaveradiationedit"
			 ,"collectmicrowaveradiationstaff"
			 ,"WL9",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 紫外辐射
	  */
	 ULTRAVIOLETLIGHT(10,"紫外辐射",false,2,"collectultravioletlight","collectultravioletlighttr","collectultravioletlightedit"
			 ,"collectultravioletlightstaff"
			 ,"WL10",LimitValueTable.l_08_4_occupational_risk_factors_wl),  
	 /**
	  * 工频电场
	  */
	 POWERFREQUENCY(11,"工频电场",false,2,"collectpowerfrequency","collectpowerfrequencytr","collectpowerfrequencyedit"
			 ,"collectpowerfrequencystaff"
			 ,"WL12",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 高温
	  */
	 HIGHTEMPERATURE(12,"高温",false,2,"collecthightemperature","collecthightemperaturetr","collecthightemperatureedit"
			 ,"collecthightemperaturestaff"
			 ,"WL2",LimitValueTable.l_08_4_occupational_risk_factors_wl), 
	 /**
	  * 激光辐射
	  */
	 LASERRADIATION(13,"激光辐射",false,2,"collectlaserradiation","collectlaserradiationtr","collectlaserradiationedit"
			 ,"collectlaserradiationstaff"
			 ,"WL7",LimitValueTable.l_08_4_occupational_risk_factors_wl),
	 /**
	  * 照度
	  */
	 ILLUMINANCY(14,"照度",false,3,"collectilluminancy","collectilluminancytr","collectilluminancyedit"
			 ,"collectilluminancystaff"
			 ,null,null),
	 /**
	  * 微小气候
	  */
	 MICROCLIMATE(15,"微小气候",false,3,"collectmicroclimate","collectmicroclimatetr","collectmicroclimateedit"
			 ,"collectmicroclimatestaff"
			 ,null,null),
	 /**
	  * 风速
	  */
	 WINDSPEED(16,"风速",false,3,"collectwindspeed","collectwindspeedtr","collectwindspeededit"
			 ,"collectwindspeedstaff"
			 ,null,null), 
	 /**
	  * 新风量
	  */
	 FRESHAIRRATE(17,"新风量",false,3,"collectfreshairrate","collectfreshairratetr","collectfreshairrateedit"
			 ,"collectfreshairratestaff"
			 ,null,null);
	 
	 private Integer code; //编号
	 
	 private String name; //名称
	 
	 private Boolean selected; //是否选中
	 
	 private  Integer groupId; //组号
	 
	 private  String page; //所对应的界面
	 
	 private String pageEdit; //所对应的编辑界面
	 
	 private String trPage;  //tr片段用于新增 编辑操作
	 
	 private String staffPage;  //人员岗位相关界面
	 
	 private String paramCode;//test库里面，危害因素的编码，如果是null，则需要具体的子类危害因素编码
	 
	 /**
	 * 限值存储的数据库表
	 */
	private LimitValueTable limitValueTable;
	 
	 private ResultCollectType(Integer code,String name,Boolean selected,Integer groupId,String page,String trPage,String pageEdit,String staffPage,String paramCode,LimitValueTable limitValueTable){
		 this.code=code;
		 this.name=name;
		 this.selected=selected;
		 this.groupId=groupId;
		 this.page=page;
		 this.pageEdit=pageEdit;
		 this.trPage=trPage;
		 this.staffPage=staffPage;
		 this.paramCode=paramCode;
		 this.limitValueTable=limitValueTable;
	 }

	 
	/**
	 * 根据危害因素，获取结果相关配置枚举数据
	 * <li>add by shao @20170402
	 * @param num
	 * @return
	 */
    public static ResultCollectType getResultTypeByCode(Integer code){
    	for (ResultCollectType c : values()) {  
            if (code.intValue() == c.getCode().intValue()) {  
                return c;  
            }  
        }  
    	
        return null;  
    }
	 
	 
	 /**
	  * 获取危害因素类型对应的属性名称相关信息
	  * @param ResultCollectTypeCode 危害因素编码
	  * @return 危害因素属性名称相关信息列表
	  */
	 public static List<ResultAttributeName> getResultAttributeNameListByCode(Integer ResultCollectTypeCode,HcCheckPlanSystemName systemName){
		 if(ResultCollectTypeCode==null || systemName == null){
			 return null;
		 }
		 boolean isArea=false;
		 boolean isPost=false;
		 if(HcCheckPlanSystemName.area.ordinal() == systemName.ordinal()) {
			 isArea = true;
		 } else if(HcCheckPlanSystemName.post.ordinal() == systemName.ordinal()) {
			 isPost=true;
		 }
		 
		 List<ResultAttributeName> list=new ArrayList<ResultAttributeName>();
		 for(ResultAttributeName resultAttributeName:ResultAttributeName.values()){
			 if(ResultCollectTypeCode.equals(resultAttributeName.getType().getCode())){
				 if(resultAttributeName.getIsArea() && isArea) {
					 list.add(resultAttributeName);
					 continue;
				 } else if(resultAttributeName.getIsPost() && isPost) {
					 list.add(resultAttributeName);
					 continue;
				 }
				 
			 }
		 }
		 return list;
	 }
	 public static  String getCodeByName(String name){
		for(ResultCollectType r:ResultCollectType.values()){
			if(r.getName().equals(name)){
				
			}
		}   
		 return "";
	 }
	 public static  String getNameByCode(Integer code){
		 String name="";
			for(ResultCollectType r:ResultCollectType.values()){
				if(r.getCode()==code){
					name=r.getName();
				}
			}   
			 return name;
		 }
	 
	public Boolean getSelected() {
		return selected;
	}

	public void setSelected(Boolean selected) {
		this.selected = selected;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public Integer getGroupId() {
		return groupId;
	}
	public String getPage() {
		return page;
	}
	public String getPageEdit() {
		return pageEdit;
	}
	public String getTrPage() {
		return trPage;
	}
	public String getStaffPage() {
		return staffPage;
	}

	public String getParamCode() {
		return paramCode;
	}

	public void setParamCode(String paramCode) {
		this.paramCode = paramCode;
	}

	public LimitValueTable getLimitValueTable() {
		return limitValueTable;
	}

	public void setLimitValueTable(LimitValueTable limitValueTable) {
		this.limitValueTable = limitValueTable;
	}
    public  static String getParamCodeByCode(String code){
    	String paramCode="";
    	ResultCollectType[] values=ResultCollectType.values();
    	for(ResultCollectType r:values){
    		if((r.code+"").equals(code)){
    			paramCode=r.paramCode;
    			break;
    		}
    	}
    	return paramCode;
    }
    public static  Integer  getCodeByParamCode(Integer paramCode){
    	Integer code=null;
    	ResultCollectType[] values=ResultCollectType.values();
    	for(ResultCollectType r:values){
    		if(paramCode.equals(r.getParamCode())){
    			code=r.getCode();
    			break;
    		}
    	}
    	
    	return code;
    }
}
