package cn.smarthse.modules.health.vo.archive;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.StringUtils;

public enum ResultAttributeName {

	//ᴀᴃᴄᴅᴇᴊᴋᴌᴍᴎᴏᴑᴘ	ᴙ	ᴚ	ᴛ	ᴜ	ᴝ	ᴞ	ᴟ	ᴠ	ᴡ	ᴢ	ᴣ	s	ᴥ	ᴦ	ᴧ	ᴨ	ᴩ	ᴪ	ᴫ
	//化学物质
	chemmical_cmac("cmac",ResultCollectType.CHEMICAL,"Cᴍᴇ(mg/m³)","MAC(mg/m³)",false,false,1,1,false,false,false,false,null,LimitValueTableField.MAC,null,true,true),
	chemical_ctwa("ctwa",ResultCollectType.CHEMICAL,"Cᴛᴡᴀ(mg/m³)","PC-TWA(mg/m³)",false,false,2,1,false,false,false,false,null,LimitValueTableField.PC_TWA,null,false,true),
	chemical_cstel1("cstel1",ResultCollectType.CHEMICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",true,false,3,1,false,false,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	chemical_cstel2("cstel2",ResultCollectType.CHEMICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",false,false,3,2,false,true,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	chemical_cstel3("cstel3",ResultCollectType.CHEMICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",false,false,3,3,false,false,true,false,null,LimitValueTableField.PC_STEL,null,true,true),
	chemical_times("times",ResultCollectType.CHEMICAL,"Cpᴇ(mg/m³)","PE(mg/m³)",false,false,4,1,false,false,false,false,null,LimitValueTableField.Max_excursion_limit,null,true,true),
	chemical_peakcontactconcentration("peakcontactconcentration",ResultCollectType.CHEMICAL,"峰接触浓度","mg/m³",false,false,3,4,false,false,false,false,null,LimitValueTableField.Peakcontactconcentration,null,true,true),
	//生物因素
	biological_cmac1("cmac1",ResultCollectType.BIOLOGICAL,"Cᴍᴇ(mg/m³)","MAC(mg/m³)",false,true,5,1,false,false,false,false,null,LimitValueTableField.MAC,null,true,true),
	biological_cmac2("cmac2",ResultCollectType.BIOLOGICAL,"Cᴍᴇ(mg/m³)","MAC(mg/m³)",false,false,6,2,false,false,false,true,null,LimitValueTableField.MAC,null,true,true),
	biological_ctwa1("ctwa1",ResultCollectType.BIOLOGICAL,"Cᴛᴡᴀ(mg/m³)","PC-TWA(mg/m³)",false,true,7,1,false,false,false,false,null,LimitValueTableField.PC_TWA,null,true,true),
	biological_ctwa2("ctwa2",ResultCollectType.BIOLOGICAL,"Cᴛᴡᴀ(mg/m³)","PC-TWA(mg/m³)",false,false,7,2,false,false,false,true,null,LimitValueTableField.PC_TWA,null,true,true),
	biological_cstel1("cstel1",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",true,true,8,1,false,false,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_cstel2("cstel2",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",false,true,8,2,false,true,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_cstel3("cstel3",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",false,true,8,3,false,false,true,false,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_cstel4("cstel4",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(mg/m³)","PC-STEL(mg/m³)",false,false,8,4,false,false,false,true,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_times("times",ResultCollectType.BIOLOGICAL,"Cpᴇ(mg/m³)","PE(mg/m³)",false,false,9,1,false,false,false,false,null,LimitValueTableField.Max_excursion_limit,null,true,true),
	biological_cmac11("cmac11",ResultCollectType.BIOLOGICAL,"Cᴍᴇ(孢子数/m³)","MAC(孢子数/m³)",false,false,10,1,false,false,false,false,null,LimitValueTableField.MAC,null,true,true),
	biological_cmac12("cmac12",ResultCollectType.BIOLOGICAL,"Cᴍᴇ(孢子数/m³)","MAC(孢子数/m³)",false,false,10,2,true,false,false,false,null,LimitValueTableField.MAC,null,true,true),
	biological_ctwa11("ctwa11",ResultCollectType.BIOLOGICAL,"Cᴛᴡᴀ(ng/m³)","PC-TWA(ng/m³)",false,false,11,1,false,false,false,false,null,LimitValueTableField.PC_TWA,null,true,true),
	biological_cstel13("cstel13",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(ng/m³)","PC-STEL(ng/m³)",true,false,12,1,false,false,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_cstel14("cstel14",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(ng/m³)","PC-STEL(ng/m³)",false,false,12,2,false,false,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	biological_cstel15("cstel15",ResultCollectType.BIOLOGICAL,"Csᴛᴇ(ng/m³)","PC-STEL(ng/m³)",false,false,12,3,false,false,false,false,null,LimitValueTableField.PC_STEL,null,true,true),
	
	
	//粉尘(区域显示两个，岗位显示4个)
	dust_ctwa1("ctwa1",ResultCollectType.DUST,"Cᴛᴡᴀ总尘(mg/m³)","PC-TWA总尘(mg/m³)",false,false,13,1,false,false,false,false,null,LimitValueTableField.PC_TWA_TOTAL,null,false,true),
	dust_times1("times1",ResultCollectType.DUST,"Cpᴇ总尘(mg/m³)","PE总尘(mg/m³)",false,false,14,1,false,false,false,false,null,LimitValueTableField.Max_excursion_limit,null,true,true),
	dust_ctwa2("ctwa2",ResultCollectType.DUST,"Cᴛᴡᴀ呼尘(mg/m³)","PC-TWA呼尘(mg/m³)",false,false,15,1,false,false,false,false,null,LimitValueTableField.PC_TWA_Respirable,null,false,true),
	dust_times2("times2",ResultCollectType.DUST,"Cpᴇ呼尘(mg/m³)","PE呼尘(mg/m³)",false,false,16,1,false,false,false,false,null,LimitValueTableField.Max_excursion_limit,null,true,true),
	dust_peakcontactconcentration1("peakcontactconcentration1",ResultCollectType.DUST,"峰接触浓度(总尘)","mg/m³",false,false,67,1,false,false,false,false,null,LimitValueTableField.Peakcontactconcentration_TOTAL,null,true,true),
	dust_peakcontactconcentration2("peakcontactconcentration2",ResultCollectType.DUST,"峰接触浓度(呼尘)","mg/m³",false,false,67,2,false,false,false,false,null,LimitValueTableField.Peakcontactconcentration_Respirable,null,true,true),
	//噪声
	noise_checkvalue("checkvalue",ResultCollectType.NOISE,"检测数值[dB(A)]","检测数值[dB(A)]",false,false,17,1,false,false,false,false,null,null,Constants.EMPTY_CHAR,true,false),
//	noise_minvalue("minvalue",ResultCollectType.NOISE,"最低值[dB(A)]",false,false,18,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	noise_maxvalue("maxvalue",ResultCollectType.NOISE,"最高值[dB(A)]",false,false,19,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	noise_equallevel("equallevel",ResultCollectType.NOISE,"8/40h等效声级[dB(A)]","8/40h等效声级[dB(A)]",false,false,20,1,false,false,false,false,null,null,"85",false,true),
//	noise_times("times",ResultCollectType.NOISE,"工作日接触脉冲次数(次)",false,false,21,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	noise_maxnoise("maxnoise",ResultCollectType.NOISE,"声压级峰值[dB(A)]","声压级峰值[dB(A)]",false,false,22,1,false,false,false,false,null,null,Constants.EMPTY_CHAR,false,true),
	
	//高频电磁场
//	highFrequency_frequency1("frequency1",ResultCollectType.HIGHFREQUENCY,"频率(f，MHz)",false,false,23,1,false,true,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	highFrequency_frequency2("frequency2",ResultCollectType.HIGHFREQUENCY,"频率(f，MHz)",false,false,23,2,false,false,true,false,null,null,Constants.EMTPY_CHAR,true,true),
//	highFrequency_time("time",ResultCollectType.HIGHFREQUENCY,"接触时间(h)",false,false,24,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	highFrequency_estrong("estrong",ResultCollectType.HIGHFREQUENCY,"电场强度(V/m)","电场强度(V/m)",false,false,25,1,false,false,false,false,null,null,"25~50",true,true),
	highFrequency_mstrong("mstrong",ResultCollectType.HIGHFREQUENCY,"磁场强度(A/m)","磁场强度(A/m)",false,false,26,1,false,false,false,false,null,null,"5",true,true),
	
	//电离辐射
//	ionizingRadiation_source("source",ResultCollectType.IONIZINGRADIATION,"放射源编号",false,false,27,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	ionizingRadiation_nuclide1("nuclide1",ResultCollectType.IONIZINGRADIATION,"核素",false,false,28,1,false,true,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	ionizingRadiation_nuclide2("nuclide2",ResultCollectType.IONIZINGRADIATION,"核素",false,false,28,2,false,false,true,false,null,null,Constants.EMTPY_CHAR,true,true),
//	ionizingRadiation_activity("activity",ResultCollectType.IONIZINGRADIATION,"活度（Bq）",false,false,29,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	ionizingRadiation_location("location",ResultCollectType.IONIZINGRADIATION,"位置",false,false,30,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	ionizingRadiation_distance("distance",ResultCollectType.IONIZINGRADIATION,"距离（cm）",false,false,31,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	ionizingRadiation_checkresult1("checkresult1",ResultCollectType.IONIZINGRADIATION,"检测结果（μSv/h）","检测结果（μSv/h）",false,false,32,1,false,true,false,false,null,null,"2.5×10^(-3) ~ &lt;5",true,true),
	ionizingRadiation_checkresult2("checkresult2",ResultCollectType.IONIZINGRADIATION,"检测结果（μSv/h）","检测结果（μSv/h）",false,false,32,2,false,false,true,false,null,null,"2.5×10^(-3) ~ &lt;5",true,true),
	
	//超高频辐射
//	ultraHighFrequencyRadiation_type("type",ResultCollectType.ULTRAHIGHFREQUENCYRADIATION,"类型",false,false,33,1,false,false,false,false,SelectEnum.ultraHighFrequencyRadiation_type,null,Constants.EMTPY_CHAR,true,true),//0连续波，1脉冲波
//	ultraHighFrequencyRadiation_time("time",ResultCollectType.ULTRAHIGHFREQUENCYRADIATION,"接触时间(h)",false,false,34,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	ultraHighFrequencyRadiation_power("power",ResultCollectType.ULTRAHIGHFREQUENCYRADIATION,"功率密度(mW/cm²)","功率密度(mW/cm²)",false,false,35,1,false,false,false,false,null,null,"0.025~0.1",true,true),
	ultraHighFrequencyRadiation_electric("electric",ResultCollectType.ULTRAHIGHFREQUENCYRADIATION,"电场强度(V/m)","电场强度(V/m)",false,false,36,1,false,false,false,false,null,null,"10~19",true,true),

	//手传振动
//	handTransmitted_time("time",ResultCollectType.HANDTRANSMITTED,"接触时间(h)",false,false,37,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	handTransmitted_speed("speed",ResultCollectType.HANDTRANSMITTED,"4h等能量频率计权振动加速度(m/s₂)","4h等能量频率计权振动加速度(m/s₂)",false,false,38,1,false,false,false,false,null,null,"5",true,true),
	
	
	//微波辐射
//	microWaverAdiation_type1("type1",ResultCollectType.MICROWAVERADIATION,"类型",false,false,39,1,false,false,false,false,SelectEnum.microWaverAdiation_type1,null,Constants.EMTPY_CHAR,true,true),//0全身辐射 ,1肢体局部辐射 
//	microWaverAdiation_type2("type2",ResultCollectType.MICROWAVERADIATION,"类型",false,false,65,1,false,false,false,false,SelectEnum.microWaverAdiation_type2,null,Constants.EMTPY_CHAR,true,true),//0连续微波，1脉冲微波
//	microWaverAdiation_time("time",ResultCollectType.MICROWAVERADIATION,"受辐射时间(h)",false,false,40,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	microWaverAdiation_amount("amount",ResultCollectType.MICROWAVERADIATION,"日剂量(μW·h/cm²)","日剂量(μW·h/cm²)",false,false,41,1,false,false,false,false,null,null,Constants.EMPTY_CHAR,true,true),
	microWaverAdiation_avgdensity("avgdensity",ResultCollectType.MICROWAVERADIATION,"平均功率密度(μW/cm²)","平均功率密度(μW/cm²)",false,false,42,1,false,false,false,false,null,null,Constants.EMPTY_CHAR,false,true),
	microWaverAdiation_powerdensity("powerdensity",ResultCollectType.MICROWAVERADIATION,"短时间接触功率密度(mW/cm²)","短时间接触功率密度(mW/cm²)",false,false,43,1,false,false,false,false,null,null,"5",true,true),
	
	//紫外辐射
//	ultravioletRadiation_classify("classify",ResultCollectType.ULTRAVIOLETLIGHT,"紫外光谱分类",false,false,44,1,false,false,false,false,SelectEnum.ultravioletRadiation_classify,null,Constants.EMTPY_CHAR,true,true),//0中波紫外线,1短波紫外线,2电焊弧光
//	ultravioletRadiation_time("time",ResultCollectType.ULTRAVIOLETLIGHT,"接触时间(h)",false,false,45,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	ultravioletRadiation_irradiance("irradiance",ResultCollectType.ULTRAVIOLETLIGHT,"辐照度(μW/cm²)","辐照度(μW/cm²)",false,false,46,1,false,false,false,false,null,null,"0.13~0.26",true,true),
	ultravioletRadiation_exposure("exposure",ResultCollectType.ULTRAVIOLETLIGHT,"照射量(mJ/cm²)","照射量(mJ/cm²)",false,false,47,1,false,false,false,false,null,null,"1.8~3.7",true,true),
	
	//工频电场
//	powerFrequency_time("time",ResultCollectType.POWERFREQUENCY,"接触时间(h)",false,false,48,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	powerFrequency_power("power",ResultCollectType.POWERFREQUENCY,"电场强度（kV/m）","电场强度（kV/m）",false,false,49,1,false,false,false,false,null,null,"5",true,true),
	
	//高温
//	highTemperature_time("time",ResultCollectType.HIGHTEMPERATURE,"接触时间率（%）",false,false,50,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	highTemperature_strong("strong",ResultCollectType.HIGHTEMPERATURE,"体力劳动强度",false,false,51,1,false,false,false,false,SelectEnum.highTemperature_strong,null,Constants.EMTPY_CHAR,true,true),//0 Ⅰ,1 Ⅱ,2 Ⅲ,3 Ⅳ
	highTemperature_checkresult("checkresult",ResultCollectType.HIGHTEMPERATURE,"检测结果(℃)","检测结果(℃)",false,false,52,1,false,false,false,false,null,null,"25~33",true,true),
	
	//激光辐射
//	laserRadiation_location("location",ResultCollectType.LASERRADIATION,"接触部位",false,false,53,1,false,false,false,false,SelectEnum.laserRadiation_location,null,Constants.EMTPY_CHAR,true,true),//0眼，1皮肤
//	laserRadiation_time("time",ResultCollectType.LASERRADIATION,"接触时间(h)",false,false,54,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	laserRadiation_range("range",ResultCollectType.LASERRADIATION,"光谱范围",false,false,55,1,false,false,false,false,SelectEnum.laserRadiation_range,null,Constants.EMTPY_CHAR,true,true),//0紫外线,1可见光,2红外线,3远红外线
//	laserRadiation_wavelength("wavelength",ResultCollectType.LASERRADIATION,"波长(n/m)",false,false,56,1,false,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	laserRadiation_irradiationtime1("irradiationtime1",ResultCollectType.LASERRADIATION,"照射时间(s)",false,false,57,1,false,true,false,false,null,null,Constants.EMTPY_CHAR,true,true),// ×10 (乘以10)
//	laserRadiation_irradiationtime2("irradiationtime2",ResultCollectType.LASERRADIATION,"照射时间(s)",false,false,57,2,true,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
//	laserRadiation_irradiationtime3("irradiationtime3",ResultCollectType.LASERRADIATION,"照射时间(s)",false,false,57,3,false,false,true,false,null,null,Constants.EMTPY_CHAR,true,true),// ×10 (乘以10)
//	laserRadiation_irradiationtime4("irradiationtime4",ResultCollectType.LASERRADIATION,"照射时间(s)",false,false,57,4,true,false,false,false,null,null,Constants.EMTPY_CHAR,true,true),
	laserRadiation_exposure1("exposure1",ResultCollectType.LASERRADIATION,"照射量(J/cm²)","照射量(J/cm²)",false,false,58,1,false,true,false,false,null,null,Constants.EMPTY_CHAR,true,true),// ×10 (乘以10)
	laserRadiation_exposure2("exposure2",ResultCollectType.LASERRADIATION,"照射量(J/cm²)","照射量(J/cm²)",false,false,58,2,true,false,false,false,null,null,Constants.EMPTY_CHAR,true,true),
	laserRadiation_exposure3("exposure3",ResultCollectType.LASERRADIATION,"照射量(J/cm²)","照射量(J/cm²)",false,false,58,3,false,false,true,false,null,null,Constants.EMPTY_CHAR,true,true),// ×10 (乘以10)
	laserRadiation_exposure4("exposure4",ResultCollectType.LASERRADIATION,"照射量(J/cm²)","照射量(J/cm²)",false,false,58,4,true,false,false,false,null,null,Constants.EMPTY_CHAR,true,true),
	laserRadiation_irradiance1("irradiance1",ResultCollectType.LASERRADIATION,"辐照度(W/cm²)","辐照度(W/cm²)",false,false,59,1,false,true,false,false,null,null,Constants.EMPTY_CHAR,true,true),// ×10 (乘以10)
	laserRadiation_irradiance2("irradiance2",ResultCollectType.LASERRADIATION,"辐照度(W/cm²)","辐照度(W/cm²)",false,false,59,2,true,false,false,false,null,null,Constants.EMPTY_CHAR,true,true),
	laserRadiation_irradiance3("irradiance3",ResultCollectType.LASERRADIATION,"辐照度(W/cm²)","辐照度(W/cm²)",false,false,59,3,false,false,true,false,null,null,Constants.EMPTY_CHAR,true,true),// ×10 (乘以10)
	laserRadiation_irradiance4("irradiance4",ResultCollectType.LASERRADIATION,"辐照度(W/cm²)","辐照度(W/cm²)",false,false,59,4,true,false,false,false,null,null,Constants.EMPTY_CHAR,true,true),
	
	//照度
	illuminancy_checkresult("checkresult",ResultCollectType.ILLUMINANCY,"检测结果(Lx)","检测结果(Lx)",false,false,60,1,false,false,false,false,null,null,null,true,true),
	
	//微小气候
	microClimate_checkresult1("checkresult1",ResultCollectType.MICROCLIMATE,"温度(℃)","温度(℃)",false,false,61,1,false,false,false,false,null,null,null,true,true),
	microClimate_checkresult2("checkresult2",ResultCollectType.MICROCLIMATE,"风速(m/s)","风速(m/s)",false,false,62,1,false,false,false,false,null,null,null,true,true),
	microClimate_checkresult3("checkresult3",ResultCollectType.MICROCLIMATE,"相对湿度(%)","相对湿度(%)",false,false,63,1,false,false,false,false,null,null,null,true,true),
	
	
	//风速
	windSpeed_checkresult("checkresult",ResultCollectType.WINDSPEED,"检测结果(m/s)","检测结果(m/s)",false,false,64,1,false,false,false,false,null,null,null,true,true),
	
	//新风量
	freshAirRate_checkresult("checkresult",ResultCollectType.FRESHAIRRATE,"检测结果(m³/h)","检测结果(m³/h)",false,false,66,1,false,false,false,false,null,null,null,true,true),
	
	; 
	
	//KV里面的属性名称（dataname）
	private String name;
	//危害因素类型
	private ResultCollectType type;
	//变量的单位，必须以小括号括起来（自定义单位可能需要替换括号里面的内容，以括号为标识截取的字符串）
	private String unit;
	
	//限值单位
	private String limitUnit;
	//是否为比较字符：0,－、1,＜、2,≤
	private Boolean isCompareChar;
	//是否自定义单位(true:该属性是自定义单位，单位存放的变量名存放在unit属性里)
	private Boolean isCustomUnit;
	//分组标识：相同的，则为同一行数据。
	private Integer groupNumber;
	
	//排序编号
	private Integer order;
	
	//是否为上标
	private Boolean isSup;
	
	/**
	 * 是否范围
	 */
	private Boolean isRangeMax;
	
	/**
	 * 是否范围数据（小）
	 */
	private Boolean isRangeMin;
	
	/**
	 * 是否为单位
	 */
	private Boolean isUnit;
	
	/**
	 * 选项值枚举
	 */
	private SelectEnum select;
	
	/**
	 * 超限值字段
	 */
	private LimitValueTableField field;
	
	/**
	 * 限值
	 */
	private String limitValue;
	
	/**
	 *  是否区域检测中需要此数据
	 */
	private Boolean isArea;
	
	/**
	 * 是否岗位检测中需要此数据
	 */
	private Boolean isPost;
	
	// 构造方法
	private ResultAttributeName(String name,ResultCollectType type,String unit,String limitUnit,Boolean isCompareChar,Boolean isCustomUnit
			,Integer groupNumber,Integer order,Boolean isSup,Boolean isRangeMin,Boolean isRangeMax
			,Boolean isUnit,SelectEnum select,LimitValueTableField field,String limitValue,Boolean isArea
			,Boolean isPost) {
		this.name = name;
		this.type = type;
		this.unit=unit;
		this.isCompareChar=isCompareChar;
		this.isCustomUnit=isCustomUnit;
		this.groupNumber=groupNumber;
		this.order=order;
		this.isSup=isSup;
		this.isRangeMax=isRangeMax;
		this.isUnit=isUnit;
		this.select=select;
		this.isRangeMin=isRangeMin;
		this.field=field;
		this.limitValue=limitValue;
		this.isArea = isArea;
		this.isPost = isPost;
		this.limitUnit = limitUnit;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public ResultCollectType getType() {
		return type;
	}
	public void setType(ResultCollectType type) {
		this.type = type;
	}
	
	public String getUnit(){
		return unit;
	}
	
	
	
	public Boolean getIsArea() {
		return isArea;
	}
	public void setIsArea(Boolean isArea) {
		this.isArea = isArea;
	}
	public Boolean getIsPost() {
		return isPost;
	}
	public void setIsPost(Boolean isPost) {
		this.isPost = isPost;
	}
	
	/**
	 * 获取真实的单位（替换自定义单位模板里面的单位为检测结果customUnit）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2019年1月14日-上午11:36:01
	 * @param customUnit 自定义单位
	 * @return
	 */
	public String getRealUnit(String customUnit) {
		//自定义单位，从自定义单位里面去找出单位
		boolean hasCustomUnit=false;
		String resultUnit = "";
		
		if(this.isCustomUnit && StringUtils.isNotEmpty(customUnit)){
			String subStr=this.getRealUnit().substring(this.getRealUnit().indexOf("("), this.getRealUnit().lastIndexOf(")")+1);
			resultUnit = this.getRealUnit().replace(subStr, "("+customUnit+")");
			hasCustomUnit = true;
		}
		if(!hasCustomUnit){
			//如果没有自定义单位为空，则使用枚举里面的默认单位
			resultUnit = this.getRealUnit();
		}
		return resultUnit;
	}
	
	/**
	 * 获取真实的单位（unit里面可能存放的是单位的索引，此方式不可取，需改正，需改正，需改正：属性不能存在多种意义，不能存放多种意义的变量）
	 * @return
	 */
	private String getRealUnit() {
		if (this.isCustomUnit) {
			for (ResultAttributeName name:values()) {
				if (name.getName().equals(this.unit)) {
					return name.unit;
				}
			}
		} else {
			return unit;
		}
		return "";
	}
	public void setUnit(String unit) {
		this.unit = unit;
	}
	
	public Integer getGroupNumber() {
		return groupNumber;
	}
	public void setGroupNumber(Integer groupNumber) {
		this.groupNumber = groupNumber;
	}
	public Integer getOrder() {
		return order;
	}
	public void setOrder(Integer order) {
		this.order = order;
	}
	public Boolean getIsSup() {
		return isSup;
	}
	public void setIsSup(Boolean isSup) {
		this.isSup = isSup;
	}
	public Boolean getIsCompareChar() {
		return isCompareChar;
	}
	public void setIsCompareChar(Boolean isCompareChar) {
		this.isCompareChar = isCompareChar;
	}
	public Boolean getIsCustomUnit() {
		return isCustomUnit;
	}
	public void setIsCustomUnit(Boolean isCustomUnit) {
		this.isCustomUnit = isCustomUnit;
	}
	public Boolean getIsRangeMax() {
		return isRangeMax;
	}
	public void setIsRangeMax(Boolean isRangeMax) {
		this.isRangeMax = isRangeMax;
	}
	public Boolean getIsUnit() {
		return isUnit;
	}
	public void setIsUnit(Boolean isUnit) {
		this.isUnit = isUnit;
	}
	public SelectEnum getSelect() {
		return select;
	}
	public void setSelect(SelectEnum select) {
		this.select = select;
	}
	public Boolean getIsRangeMin() {
		return isRangeMin;
	}
	public void setIsRangeMin(Boolean isRangeMin) {
		this.isRangeMin = isRangeMin;
	}
	public LimitValueTableField getField() {
		return field;
	}
	public void setField(LimitValueTableField field) {
		this.field = field;
	}
	public String getLimitValue() {
		return limitValue;
	}
	public void setLimitValue(String limitValue) {
		this.limitValue = limitValue;
	}
	public String getLimitUnit() {
		return limitUnit;
	}
	public void setLimitUnit(String limitUnit) {
		this.limitUnit = limitUnit;
	}
	
	
	

}
