package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

public class HarmFactorTestQuarterSummaryResultVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 属性
	 */
	private ResultAttributeName attribute;
	
	/**
	 * 检测结果前面的符号，可能为空，可能为<等。
	 */
	private String maxResultBefore;
	
	private String minResuoltBefore;
	
	/**
	 * 检测结果最小值(数字)
	 */
	private BigDecimal resultMinNumber;
	
	/**
	 * 最小值的次方
	 */
	private Integer resultMinPower;

	/**
	 * 最大值的次方
	 */
	private Integer resultMaxPower;
	

	/**
	 * 检测结果最小值（字符）
	 */
	private String resultMinStr;
	
	/**
	 * 检测结果最大值(数字)
	 */
	private BigDecimal resultMaxNumber;
	

	/**
	 * 检测结果最大值（字符）
	 */
	private String resultMaxStr;
	
	/**
	 * 单位
	 */
	private String unit;
	
	/**
	 * 职业接触限制
	 */
	private String touchLimit;
	
	/**
	 * 职业接触限值单位
	 */
	private String touchLimitUnit;
	
	/**
	 * 返回结果
	 */
	private String resultStr;
	
	/**
	 * 结果判定（微小气候特有）
	 */
	private String resultText;

	public String getResultText() {
		return resultText;
	}

	public void setResultText(String resultText) {
		this.resultText = resultText;
	}

	public ResultAttributeName getAttribute() {
		return attribute;
	}
	
	public void setAttribute(ResultAttributeName attribute) {
		this.attribute = attribute;
	}

	public String getMaxResultBefore() {
		return maxResultBefore;
	}

	public void setMaxResultBefore(String maxResultBefore) {
		this.maxResultBefore = maxResultBefore;
	}

	public String getMinResuoltBefore() {
		return minResuoltBefore;
	}

	public void setMinResuoltBefore(String minResuoltBefore) {
		this.minResuoltBefore = minResuoltBefore;
	}

	public BigDecimal getResultMinNumber() {
		return resultMinNumber;
	}

	public void setResultMinNumber(BigDecimal resultMinNumber) {
		this.resultMinNumber = resultMinNumber;
	}
	
	public void setResultNumber(BigDecimal resultNumber/*,String numBefore*/){
		if(resultNumber==null){
			return;
		}
		if(this.resultMinNumber == null || this.resultMinNumber.compareTo(resultNumber)>0){
			this.resultMinNumber=resultNumber;
//			this.minResuoltBefore=numBefore;
		}
		if(this.resultMaxNumber == null || this.resultMaxNumber.compareTo(resultNumber)<0){
			this.resultMaxNumber=resultNumber;
//			this.maxResultBefore=numBefore;
		}
	}

	public String getResultMinStr() {
		return resultMinStr;
	}

	public void setResultMinStr(String resultMinStr) {
		this.resultMinStr = resultMinStr;
	}

	public BigDecimal getResultMaxNumber() {
		return resultMaxNumber;
	}

	public void setResultMaxNumber(BigDecimal resultMaxNumber) {
		this.resultMaxNumber = resultMaxNumber;
	}

	public String getResultMaxStr() {
		return resultMaxStr;
	}

	public void setResultMaxStr(String resultMaxStr) {
		this.resultMaxStr = resultMaxStr;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getTouchLimit() {
		return touchLimit;
	}

	public void setTouchLimit(String touchLimit) {
		this.touchLimit = touchLimit;
	}

	public String getTouchLimitUnit() {
		return touchLimitUnit;
	}

	public void setTouchLimitUnit(String touchLimitUnit) {
		this.touchLimitUnit = touchLimitUnit;
	}

	public Integer getResultMinPower() {
		return resultMinPower;
	}

	public void setResultMinPower(Integer resultMinPower) {
		this.resultMinPower = resultMinPower;
	}

	public Integer getResultMaxPower() {
		return resultMaxPower;
	}

	public void setResultMaxPower(Integer resultMaxPower) {
		this.resultMaxPower = resultMaxPower;
	}

	public String getResultStr() {
		resultStr = "";
		if(attribute == null || attribute.getName().startsWith("cmac") || attribute.getName().startsWith("ctwa")) {
			//返回最大值
			if(this.resultMaxNumber!=null){
				if(this.maxResultBefore!=null) {
					resultStr = resultStr + maxResultBefore;
				}
				resultStr = resultStr + this.resultMaxNumber.toString();
			}
		}else {
			//返回范围
			if(this.resultMinNumber!=null){
				if(this.minResuoltBefore!=null) {
					resultStr = resultStr+minResuoltBefore;
				}
				resultStr = resultStr + resultMinNumber.toString();
				if(this.resultMaxNumber!=null){
					if(this.resultMinNumber.compareTo(this.resultMaxNumber)==0){

					}else{
						resultStr = resultStr +"～";
						if(this.maxResultBefore!=null) {
							resultStr = resultStr + maxResultBefore;
						}
						resultStr = resultStr + this.resultMaxNumber.toString();
					}
				}
			}else if(this.resultMaxNumber !=null){
				if(this.maxResultBefore!=null) {
					resultStr = resultStr + maxResultBefore;
				}
				resultStr = resultStr + this.resultMaxNumber.toString();
			} else{
				return "";
			}
		}
		
		return resultStr;
	}
	
	public void merge(HarmFactorTestQuarterSummaryResultVO vo){
		if(ResultCollectType.MICROCLIMATE.getName().equals(vo.getAttribute().getType().getName())) {
			//微小气候
			//合并检测结果
			if(HcCheckResultTypeEnum.NOTACCORD.getName().equals(vo.getResultText())) {
				this.resultText = vo.getResultText();
			}
		}
		if(ResultAttributeName.laserRadiation_exposure1.name().equals(vo.getAttribute().name()) || ResultAttributeName.laserRadiation_irradiance1.name().equals(vo.getAttribute().name())){
			//激光辐射,
			if(this.resultMinNumber == null || this.resultMinNumber.compareTo(vo.getResultMinNumber())>0){
				//合并过来的比原本的小。
				this.resultMinPower=vo.getResultMinPower();
				this.resultMinNumber=vo.getResultMinNumber();
				this.resultMinStr=vo.getResultMinStr();
			}
			
			if(this.resultMaxNumber == null || this.resultMaxNumber.compareTo(vo.getResultMaxNumber())<0){
				//合并过来的比原本的大。
				this.resultMaxPower=vo.getResultMaxPower();
				this.resultMaxNumber=vo.getResultMaxNumber();
				this.resultMaxStr=vo.getResultMaxStr();
			}
			
		}else{

			if(vo.getResultMinNumber()!=null){
				if(this.resultMinNumber == null || this.resultMinNumber.compareTo(vo.getResultMinNumber())>0){
					this.resultMinNumber=vo.getResultMinNumber();
					this.minResuoltBefore=vo.getMinResuoltBefore();
				}
				if(this.resultMaxNumber == null || this.resultMaxNumber.compareTo(vo.getResultMinNumber())<0){
					this.resultMaxNumber=vo.getResultMinNumber();
					this.maxResultBefore=vo.getMinResuoltBefore();
				}
			}
			
			
			if(vo.getResultMaxNumber()!=null){
				if(this.resultMinNumber == null || this.resultMinNumber.compareTo(vo.getResultMaxNumber())>0){
					this.resultMinNumber=vo.getResultMaxNumber();
					this.minResuoltBefore=vo.getMaxResultBefore();
				}
				if(this.resultMaxNumber == null || this.resultMaxNumber.compareTo(vo.getResultMaxNumber())<0){
					this.resultMaxNumber=vo.getResultMaxNumber();
					this.maxResultBefore=vo.getMaxResultBefore();
				}
			}
		
//			this.setResultNumber(vo.getResultMinNumber());
//			this.setResultNumber(vo.getResultMaxNumber());
		}
		
	}
	
}
