package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HarmFactorTestQuarterSummaryDataVO implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 职业病危害因素名称
	 */
	private String harmFactorName;
	
	/**
	 * 危害因素ID(可能是大类（枚举类），可能是小类（危害因素：OccupationalRiskFactors）) 
	 */
	private Long harmFactorId;
	
	/**
	 *检测周期字符差U呢
	 */
	private String checkCycleStr;
	
	/**
	 * 监测周期（最小值）
	 */
	private Integer checkCycleMin;
	
	/**
	 * 检测周期，最大值
	 */
	private Integer checkCycleMax;
	
	/**
	 * 采样点数目，默认1
	 */
	private Integer pointNumber = 1;
	
	/**
	 * 结果判定
	 */
	private String resultText;
	
	//数据行数
	private Integer lineNum;
	
	/**
	 * 检测结果及限值
	 */
	private List<HarmFactorTestQuarterSummaryResultVO> resultList = new ArrayList<HarmFactorTestQuarterSummaryResultVO>();

	public String getHarmFactorName() {
		return harmFactorName;
	}

	public void setHarmFactorName(String harmFactorName) {
		this.harmFactorName = harmFactorName;
	}

	public Long getHarmFactorId() {
		return harmFactorId;
	}

	public void setHarmFactorId(Long harmFactorId) {
		this.harmFactorId = harmFactorId;
	}

	public Integer getCheckCycleMin() {
		return checkCycleMin;
	}

	public void setCheckCycleMin(Integer checkCycleMin) {
		this.checkCycleMin = checkCycleMin;
	}

	public Integer getCheckCycleMax() {
		return checkCycleMax;
	}

	public void setCheckCycleMax(Integer checkCycleMax) {
		this.checkCycleMax = checkCycleMax;
	}

	public Integer getPointNumber() {
		return pointNumber;
	}

	public void setPointNumber(Integer pointNumber) {
		this.pointNumber = pointNumber;
	}

	public String getResultText() {
		return resultText;
	}

	public void setResultText(String resultText) {
		this.resultText = resultText;
	}

	public List<HarmFactorTestQuarterSummaryResultVO> getResultList() {
		return resultList;
	}

	public void setResultList(List<HarmFactorTestQuarterSummaryResultVO> resultList) {
		this.resultList = resultList;
	}

	public String getCheckCycleStr() {
		if(this.checkCycleMin!=null){
			//最小值不为空
			if(this.checkCycleMax!=null){
				//最小值、最大值均不为null
				if(this.checkCycleMin.equals(this.checkCycleMax)){
					//周期最大值和最小值相等。
					this.checkCycleStr = this.checkCycleMin+"";
				}else{
					//最小值，最大值不相等
					this.checkCycleStr = this.checkCycleMin+"~"+this.checkCycleMax;
				}
			}else{
				//最小值不为空，最大值为空
				this.checkCycleStr = this.checkCycleMin+"";
			}
		}else if(this.checkCycleMax!=null){
			//最小值为空，最大值不为null
			this.checkCycleStr = this.checkCycleMax+"";
		} else {
			//最小值最大值均为空
			this.checkCycleStr = null;
		}
		return this.checkCycleStr;
	}
	
	public Integer getLineNum() {
		if(resultList == null || resultList.isEmpty()) {
			return 0;
		}

		
		return resultList.size();
	}

	public void setLineNum(Integer lineNum) {
		this.lineNum = lineNum;
	}
}
