package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;

public class HarmFactorTestQuarterSummaryCheckPlanVO implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 检测
	 */
	private HcCheckPlan  hcCheckPlan;
	
	//数据行数
	private Integer lineNum;
	
	/**
	 * 检测数据（危害因素结果列表）
	 */
	List<HarmFactorTestQuarterSummaryVO> summaryList = new ArrayList<HarmFactorTestQuarterSummaryVO>();


	public List<HarmFactorTestQuarterSummaryVO> getSummaryList() {
		return summaryList;
	}

	public void setSummaryList(List<HarmFactorTestQuarterSummaryVO> summaryList) {
		this.summaryList = summaryList;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public Integer getLineNum() {
		if(summaryList == null || summaryList.isEmpty()) {
			return 0;
		}
		int num=0;
		for(HarmFactorTestQuarterSummaryVO summaryVo:summaryList) {
			if(summaryVo.getDataList() == null || summaryVo.getDataList().isEmpty()) {
				continue;
			}
			for(HarmFactorTestQuarterSummaryDataVO dataVo : summaryVo.getDataList()) {
				if(dataVo.getResultList()==null || dataVo.getResultList().isEmpty()) {
					continue;
				}
				num+=dataVo.getResultList().size();
			}
		}
		
		return num;
	}

	public void setLineNum(Integer lineNum) {
		this.lineNum = lineNum;
	}
	
	
	
	
}
