package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.math.BigDecimal;

import cn.smarthse.common.util.StringUtils;
import lombok.Data;

public @Data class Doc6WorkPlaceHarmFactorResultValue implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 最大值
	 */
	private BigDecimal max;
	
	/**
	 * 最小值
	 */
	private BigDecimal min;
	
	private String minStr;
	
	private String maxStr;
	
	private String minPower;
	private String maxPower;
	
	/**
	 * 最大值前面的符号
	 */
	private String maxBeforChar;
	
	/**
	 * 最小值前面的符号
	 */
	private String minBeforChar;
	
	
	/**
	 * 检测结果
	 */
	private String reault;
	
	/**
	 * 检测结果单位
	 */
	private String unit;
	
	/**
	 * 检测结果属性
	 */
	private ResultAttributeName attribute;

	public ResultAttributeName getAttribute() {
		return attribute;
	}

	public void setAttribute(ResultAttributeName attribute) {
		this.attribute = attribute;
	}

	public String getReault() {
		StringBuffer resultStr = new StringBuffer();
		if(attribute == null || attribute.getName().startsWith("cmac") || attribute.getName().startsWith("ctwa") ) {
			//返回最大值
			if(max == null) {
				return reault;
			}else {
				if(maxBeforChar!=null) {
					resultStr.append(maxBeforChar);
				}
				resultStr.append(max.toString());
				return resultStr.toString();
			}
		}else {
			//返回范围
			
			if(min == null) {
				if(max == null) {
					return reault;
				}else {
					if(maxBeforChar!=null) {
						resultStr.append(maxBeforChar);
					}
					resultStr.append(max.toString());
					return resultStr.toString();
				}
			}else {
				if(minBeforChar!=null) {
					resultStr.append(minBeforChar);
				}
				resultStr.append(min.toString());
				
				if(max == null || this.min.compareTo(this.max) == 0) {
					//最大值为空，或最大值与最小值相等
					return resultStr.toString();
				}else {
					resultStr.append("~");
					if(maxBeforChar!=null) {
						resultStr.append(maxBeforChar);
					}
					resultStr.append(max.toString());
					return resultStr.toString();
				}
			}
		}
		
	}

	public void setReault(String reault) {
		this.reault = reault;
	}
	
	public void setResultNumber(BigDecimal result,String beforChar) {
		if(result == null) {
			return;
		}
		if(this.min == null || this.min.compareTo(result)>0){
			this.min=result;
			this.setMinBeforChar(beforChar);
		}
		if(this.max == null || this.max.compareTo(result)<0){
			this.max=result;
			this.setMaxBeforChar(beforChar);
		}
	}
	
	/**
	 * 设置激光辐射的结果
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2019年1月14日-下午7:16:00
	 */
	public void setLaserRadiationResultNumber(String valueStr,String powerStr) {
		if(!StringUtils.isNumber(powerStr)) return;
		BigDecimal value = new BigDecimal(valueStr);//获取数值2
		Integer power = Integer.valueOf(powerStr);//获取次方2
		BigDecimal result = null;
		if(power>0){
			result = value.multiply(new BigDecimal(10).pow((power)));//计算数值2的次方
		}else {
			result = value.multiply(new BigDecimal("0.1").pow((Math.abs(power))));//计算数值2的次方
		}

		if(this.min == null || this.min.compareTo(result)>0){
			this.min=result;
			this.minStr=valueStr;
			this.minPower=powerStr;
		}
		if(this.max == null || this.max.compareTo(result)<0){
			this.max=result;
			this.maxStr=valueStr;
			this.maxPower=powerStr;
		}
	}
	
	public void setRealNumberResult(String resultStr,String beforChar){
		if(resultStr == null){
			return ;
		}
		if(beforChar ==null) {
			beforChar = "";
		}
		resultStr=resultStr.trim();
		if(StringUtils.isEmpty(resultStr)){
			return ;
		}
		if(resultStr.length()>1){
			String firstChar = resultStr.substring(0, 1);
			if(StringUtils.isNumber(firstChar)){
				//如果结果第一个是数字，则直接返回
				BigDecimal numberData = new BigDecimal(resultStr);
				this.setResultNumber(numberData,beforChar);
			}else{
				
				//如果结果第一个字符不是数字，是字符。则将字符存入结果前缀属性里面，返回第一个字符后面的所有字符
				if(StringUtils.isBlank(beforChar)){
					beforChar = firstChar;
				}else{
					beforChar = beforChar+firstChar;
				}
				
				this.setRealNumberResult(resultStr.substring(1),beforChar);//递归调用
			}
		}else{
			//结果字符串长度不大于1，直接返回
			
		}
		
	}
	
	public void merge(Doc6WorkPlaceHarmFactorResultValue oldValue) {
		if(oldValue.getMin()!=null) {
			if(this.min == null || this.min.compareTo(oldValue.getMin())>0) {
				this.min = oldValue.getMin();
				this.minBeforChar= oldValue.getMinBeforChar();
				
				if(ResultAttributeName.laserRadiation_exposure1.name().equals(this.getAttribute().name()) || ResultAttributeName.laserRadiation_irradiance1.name().equals(this.getAttribute().name())){
					this.minStr=oldValue.getMinStr();
					this.minPower = oldValue.getMinPower();
				}
			}
			if(this.max == null || this.max.compareTo(oldValue.getMax())<0) {
				this.max = oldValue.getMax();
				this.maxBeforChar = oldValue.getMaxBeforChar();
				if(ResultAttributeName.laserRadiation_exposure1.name().equals(this.getAttribute().name()) || ResultAttributeName.laserRadiation_irradiance1.name().equals(this.getAttribute().name())){
					this.maxStr=oldValue.getMaxStr();
					this.maxPower = oldValue.getMaxPower();
				}
			}
			
		}
	}
}
