package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;

public @Data class Doc6WorkPlaceHarmFactorCheckPlan implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 检测ID
	 */
	private Long checkPlanId;
	
	/**
	 * 检测时间
	 */
	private String testTime;
	
	/**
	 * 检测机构
	 */
	private String testOrganization;
	

	private Integer lineNum;
	
	
	/**
	 * 危害因素检测结果列表
	 */
	private List<Doc6WorkPlaceHarmFactorResult> resultList = new ArrayList<>();

	public Integer getLineNum() {
		
		if(resultList.isEmpty()) {
			return 0;
		}
		int num=0;
		for(Doc6WorkPlaceHarmFactorResult result:resultList) {
			if(result.getList().isEmpty()) {
				continue;
			}
			num+=result.getList().size();
		}
		return num;
	}

}
