package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;

public @Data class Doc6WorkPlaceHarmFactor implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 岗位
	 */
	private String workPlace;
	
	/**
	 * 防护用品
	 */
	private String protectiveArticles;
	
	private Integer lineNum;
	
	
	/**
	 * 危害因素检测结果列表
	 */
	private List<Doc6WorkPlaceHarmFactorCheckPlan> checkPlanList = new ArrayList<>();

	public Integer getLineNum() {
		
		if(checkPlanList.isEmpty()) {
			return 0;
		}
		int num=0;
		for(Doc6WorkPlaceHarmFactorCheckPlan checkPlan:checkPlanList) {
			for(Doc6WorkPlaceHarmFactorResult result:checkPlan.getResultList()) {
				if(result.getList().isEmpty()) {
					continue;
				}
				num+=result.getList().size();
			}
		}
		return num;
	}

}
