/**
 * 
 */
package cn.smarthse.modules.health.vo.archive;

import java.io.Serializable;
import java.util.List;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;


/**
 * 《统一档案附件对象》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-8-上午10:34:35
 */
public @Data class ArchiveFileListVO implements Serializable {
	private static final long serialVersionUID = -6856721004031217829L;
	//附件名称(用于创建子目录)
	private String dirName;
	//附近列表
	private List<SysFileModel> fileList;
	
	public ArchiveFileListVO(){}
	
	/**
	 * 档案附件VO
	 * @param dirName		附件目录(dirName将会创建为子目录,为空则不创建)
	 * @param fileList			附件列表
	 */
	public ArchiveFileListVO(String dirName,  List<SysFileModel> fileList){
		this.dirName = dirName;
		this.fileList = fileList;
	}
}
