package cn.smarthse.modules.health.util;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformItemLevelEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceEnum;

import javax.cn.smarthse.modules.health.exception.HealthException;

public class ReformItemUtil {
	
	public static void validate(ReformItemBasic reform){
		if(reform == null) {
			throw new HealthException("参数丢失");
		}
		if(ReformSourceEnum.supervise.getValue().equals(reform.getReformItemSource())) {
			//上级监督检查
			reform.setFinder(1L);
		}
		
		if(reform.getReformItemSource()!=null 
				&& reform.getReformItemSourceId()!=null //有来源ID的隐患治理（在隐患治理页面添加的没有来源ID）
				&& ReformSourceEnum.supervise.getValue().equals(reform.getReformItemSource())){
			//上级监督检查
			if(StringUtils.isEmpty(reform.getFinderName())){
				throw new HealthException("隐患发现人不能为空");
			}
		}
		
		
		
		boolean isValidateBySource=false;
		if(reform.getIsValidateBySource()!=null){
			if(ReformSourceEnum.supervise.getValue().equals(reform.getReformItemSource()) 
					|| ReformSourceEnum.sceneInspection.getValue().equals(reform.getReformItemSource())
					|| ReformSourceEnum.evaluationManage.getValue().equals(reform.getReformItemSource())){
				//其他来源整改项
				isValidateBySource= true;
			}
		}
		
		if(!isValidateBySource){
			reform.setIsValidateBySource(false);
			ValidateUtil.valid(reform, Constants.MESSAGE_GROUP_ADD);
		}else{
			reform.setIsValidateBySource(true);
			ValidateUtil.valid(reform, Constants.MESSAGE_GROUP_INSPECTION_REFORM);

			if(ReformItemLevelEnum.majorStop.getValue().equals(reform.getReformItemLevel())){
				//重大隐患
				ValidateUtil.valid(reform.getAcceptance(), Constants.MESSAGE_GROUP_INSPECTION_REFORM_majorStop);
			}else{
				ValidateUtil.valid(reform.getAcceptance(), Constants.MESSAGE_GROUP_INSPECTION_REFORM);
			}
		}
	}
}
	
		
		
