package cn.smarthse.modules.health.util;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.archive.LiteArchiveRequiredEnum;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: LiteArchiveUtils
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 59
 * @since 2024/4/18-14:59
 */
public class LiteArchiveUtils {

    /**
     * 合规年份
     * @return
     */
    public static List<Integer> getHgArchiveYear() {
        int thisYear = DateUtils.getThisYear();
        if (thisYear == 2024) {
            return Arrays.asList(2023);
        }
        return Arrays.asList(thisYear-2, thisYear-1);
    }


    public static LiteArchiveFileItem appendFileItem(Long archiveId, Long fileNameId, String fileIds, String referFileIds, Consumer<LiteArchiveFileItem> consumer) {
        LiteArchiveFileItem item = new LiteArchiveFileItem();
        item.setLiteArchiveId(archiveId);
        item.setFileNameId(fileNameId);
        item.setFileIds(fileIds);
        item.setReferFileIds(referFileIds);
        if (consumer != null) {
            consumer.accept(item);
        }
        return item;
    }

    public static List<LiteArchiveFileDetailVo> getHgRequiredListVo(List<LiteArchiveFileDetailVo> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                if (archive.getHgIsRequired()==null||Objects.equals(archive.getHgIsRequired(),
                        LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }

                if (StringUtils.isNotBlank(archive.getFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getFileIds(), ",");
                    archive.setFileIds(StringUtils.join(fileIdList, ","));
                }
                if (StringUtils.isNotBlank(archive.getReferFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getReferFileIds(), ",");
                    archive.setReferFileIds(StringUtils.join(fileIdList, ","));
                }
                if (Objects.equals(isfinish, true)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isNotBlank(archive.getFileIds()) || StringUtils.isNotBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }

                    if ((Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && StringUtils.isNotBlank(archive.getFileIds()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    }else {
                        return false;
                    }
                } else if (Objects.equals(isfinish, false)) {

                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isBlank(archive.getFileIds()) && StringUtils.isBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }

                    if ((Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && !StringUtils.isNotBlank(archive.getFileIds()) && !Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    } else {
                        return false;
                    }
                } else  {
                    return true;
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
    public static List<LiteArchiveFileDetailVo> getCommonRequiredListVo(List<LiteArchiveFileDetailVo> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                if (archive.getIsRequired()==null||Objects.equals(archive.getIsRequired(),
                        LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }

                if (StringUtils.isNotBlank(archive.getFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getFileIds(), ",");
                    archive.setFileIds(StringUtils.join(fileIdList, ","));
                }
                if (StringUtils.isNotBlank(archive.getReferFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getReferFileIds(), ",");
                    archive.setReferFileIds(StringUtils.join(fileIdList, ","));
                }
                if (Objects.equals(isfinish, true)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isNotBlank(archive.getFileIds()) || StringUtils.isNotBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }

                    if ((Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && StringUtils.isNotBlank(archive.getFileIds()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    }else {
                        return false;
                    }
                } else if (Objects.equals(isfinish, false)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isBlank(archive.getFileIds()) && StringUtils.isBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }

                    if ((Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && !StringUtils.isNotBlank(archive.getFileIds()) && !Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    } else {
                        return false;
                    }
                } else  {
                    return true;
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
    public static List<LiteArchiveFileItem> getHgRequiredList(List<LiteArchiveFileItem> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                if (Objects.equals(archive.getHgIsRequired(),
                        LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }

                if (StringUtils.isNotBlank(archive.getFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getFileIds(), ",");
                    archive.setFileIds(StringUtils.join(fileIdList, ","));
                }
                if (StringUtils.isNotBlank(archive.getReferFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getReferFileIds(), ",");
                    archive.setReferFileIds(StringUtils.join(fileIdList, ","));
                }
                if (Objects.equals(isfinish, true)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isNotBlank(archive.getFileIds()) || StringUtils.isNotBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }
                    if ((Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && StringUtils.isNotBlank(archive.getFileIds()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    }else {
                        return false;
                    }
                } else if (Objects.equals(isfinish, false)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isBlank(archive.getFileIds()) && StringUtils.isBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }
                    if ((Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && !StringUtils.isNotBlank(archive.getFileIds()) && !Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()))
                            || (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    } else {
                        return false;
                    }
                } else  {
                    return true;
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    /**
     * 获取普通项 一般
     * @param archiveList
     * @param isfinish
     * @return
     */
    public static List<LiteArchiveFileItem> getCommonRequiredList(List<LiteArchiveFileItem> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {

                if (Objects.equals(archive.getIsRequired(),
                        LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }

                if (StringUtils.isNotBlank(archive.getFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getFileIds(), ",");
                    archive.setFileIds(StringUtils.join(fileIdList, ","));
                }
                if (StringUtils.isNotBlank(archive.getReferFileIds())) {
                    List<Long> fileIdList = CommonUtil.str2LongList(archive.getReferFileIds(), ",");
                    archive.setReferFileIds(StringUtils.join(fileIdList, ","));
                }

                if (Objects.equals(isfinish, true)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isNotBlank(archive.getFileIds()) || StringUtils.isNotBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }
                    if ((Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && StringUtils.isNotBlank(archive.getFileIds()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    }else {
                        return false;
                    }
                } else if (Objects.equals(isfinish, false)) {
                    //职业病危害告知 特殊处理
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        if (StringUtils.isBlank(archive.getFileIds()) && StringUtils.isBlank(archive.getStorageLocation())) {
                            return true;
                        }else {
                            return false;
                        }
                    }
                    if ((Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank(archive.getFileIds()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode())
                            && !StringUtils.isNotBlank(archive.getFileIds()) && !Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()))
                            || (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank(archive.getReferFileIds()))
                    ) {
                        return true;
                    } else {
                        return false;
                    }
                } else  {
                    return true;
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}
