package cn.smarthse.modules.health.param;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @ author Supw
 * @ since 2023/4/28 17:16
 */
@Data
@Accessors(chain = true)
public class WandaSearchParam implements java.io.Serializable{
    private Integer limit;
    private Integer rows;
    private Integer page=1;
    private String keywords;
    private String employerName;
    private String creditCode;
    /**
     * 体检类型编码
     */
    private String bodyCheckType;
    private String bodyCheckTypes;
    private List<String> bodyCheckTypeList;
    /**
     * 人员姓名
     */
    private String name;
    /**
     * 体检日期
     */
    private String checkTimeBegin;
    private String checkTimeEnd;

    private Boolean isConverted;


    public int getPageNum(){
        return this.page;
    }

    public int getPageSize(){
        if (limit!=null) return this.limit;
        if (rows!=null) return this.rows;
        return 10;
    }
}
