package cn.smarthse.modules.health.param;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @ author Supw
 * @ since 2023/4/28 17:16
 */
@Data
@Accessors(chain = true)
public class SearchParam implements java.io.Serializable{
    private Integer limit;
    private Integer rows;
    private Integer page=1;
    private String keywords;
    private Boolean finish;
    private Boolean closed;

    private Long areaId;
    private String areaName;
    private Byte level;
    //是否仅本级 1-仅本级 2-非本级
    private Byte companyLevel;

    private Boolean isCurrent;
    private Boolean onlyThisLevel;

    private Long cid;
    private Byte status;
    private Byte type;

    private List<Byte> statusList;

    private String unifiedSocialCc;

    /**
     * 仅查看非医用放射单位放射
     */
    private Boolean isExistRadioactivity = false;
    /**
     * 是否包含营业状态未关闭的企业
     */
    private Boolean containPausedBusiness = false;

    private Boolean pickupCount= false;//是否包含接害人数小于3的数据

    //1-三同时 2-个人防护用品 3-警示标识 4-培训 5-档案 6-申报 7-体检
    private Byte generationSource;
    private Integer belongType;

    private Long  areaParentId;
    private Long  provinceId;

    /**
     * 年份
     */
    private Integer year;
    /**
     * 企业类型（1-仅显示非劳务派遣单位,2-仅显示劳务派遣单位）
     */
    private Byte companyType;
    
    private Boolean containCompanyType;
    /**
     * 是否包含接害人数小于3的企业
     */
    private Boolean containVictimLess3Company=false;
    /**
     * 是否包含暂停营业的企业
     * 2024-5-10 优化需求  1-正常营业、2-包括暂停营业、3-包括暂停与已关闭企业
     */
    private Byte containCloseCompany;
    /**
     * 是否显示全部地市
     */
    private Boolean isCity = false;
    /**
     * 是否显示全部区县
     */
    private Boolean isCounty = false;

    /**
     * 是否过滤没有数据的区域
     */
    private Boolean filterNoDataArea=false;

    private Byte dataSource;


    private String sort;

    private String projectCode;

    private Boolean noCode=false;

    private String importBatchNo;
    private Byte businessState;
    private List<Byte> businessStateList;
    //入库原因选择
    private List<Byte> StorageList;

    private Integer isFcyth;
    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    private Integer isFcImportanceCompany;
    private Integer confirmType=1;
    /**
     * 是否匹配到企业
     */
    private Boolean isMatchCompany;

//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String beginTime;
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String endTime;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date beginDate;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    public int getPageNum(){
        return this.page;
    }

    public int getPageSize(){
        if (limit!=null) return this.limit;
        if (rows!=null) return this.rows;
        return 10;
    }

    /**
     * 系统部署来源SystemDeploymentSourceEnum
     */
    private Byte systemDeploymentSource;

    /**
     * 是否新建企业引导阶段
     */
    private Boolean isGuideNewCompany=false;

    /**
     * 是否分类对象 all,olddec,current,false,allCom所有企业
     */
    private String isClassified;

    /**
     * 仅查看粉尘企业
     */
    private Boolean onlyShowFcCompany =false;

    /**
     * 是否分类监督(all:全年是数据，current：当年数据，false:不是分类对象,olddec是历年分类对象)
     */
    private String isDeclare;

    private Byte areaLevel;
    
    /**
     * 纳入分类年份
     */
    private String enterDecYear;
}
