package cn.smarthse.modules.health.enums.wmbase;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《警示标识类型enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-6-15-上午9:59:22
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WmBaseTypeEnum {

	
	graphical_logo_and_its_corresponding_warning_statement("图形标识及其相应的警示语句",1),
	
	warning_line("警示线",2),
	
	occupational_hazards_report_card("职业病危害告知卡",3),
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private WmBaseTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (WmBaseTypeEnum c : WmBaseTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
