package cn.smarthse.modules.health.enums.trusteeship;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险预警类型
 *
 * @author ShenZQ
 * @since 2022-04-28 8:55
 */
@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskWarningTypeEnum {

    trusteeshipReport("机构上报风险", 1),

    unmanagedVerification("未托管核查", 2),

    /**
     * 超过整改期限30天未整改，进行预警
     */
    overdueRectification("整改超期", 3),

    closed("已关闭", 4),

    suspensionOfBusiness("暂停营业", 5),
    ;

    private String riskWarningType;
    private Integer value;
}
