package cn.smarthse.modules.health.enums.train;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训方式（内部、外部）
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainWayEnum {

    oneMonth("内部", (byte) 1),
    twoMonth("外部", (byte) 2),
    ;

    private String name;
    private Byte value;

    private TrainWayEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Byte value) {
        if (value == null) {
            return "";
        }
        for (TrainWayEnum c : TrainWayEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getValue() {
        return value;
    }

    public void setValue(Byte value) {
        this.value = value;
    }
}