package cn.smarthse.modules.health.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训项目-数据来源枚举
 *
 * @author 覃浩云 1770126791@qq.com
 * @date: 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainProjReportTypeEnum {

    /**
     * null、1 算其它来源
     */
    COMPANY("系统新增", 1),

    ONLINE("在线培训", 2),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainProjReportTypeEnum[] values = TrainProjReportTypeEnum.values();
        for (TrainProjReportTypeEnum certificateStaffDetailDataSourceEnum : values) {
            if (certificateStaffDetailDataSourceEnum.getValue().equals(value)) {
                return certificateStaffDetailDataSourceEnum.getName();
            }
        }
        return "";
    }

}
