package cn.smarthse.modules.health.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 培训项目-发布状态
 */
@AllArgsConstructor
@Getter
public enum TrainProfileStatusEnum {

    //1 草稿 2 已发布 3 被退回
    DRAFT("草稿", (byte) 1),
    PASSED("已发布", (byte) 2),
    REFUND("被退回", (byte) 3),
    ;

    private final String name;
    private final Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        TrainProfileStatusEnum[] values = TrainProfileStatusEnum.values();
        for (TrainProfileStatusEnum trainProfileStatusEnum : values) {
            if (Objects.equals(trainProfileStatusEnum.getValue(), value)) {
                return trainProfileStatusEnum.getName();
            }
        }
        return null;
    }

}
