package cn.smarthse.modules.health.enums.train;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <教育培训类型枚举>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年8月9日-下午5:34:43
 */
public enum TrainPlanTypeEnum {

	GQ("岗前培训（含三级教育）", (byte) 1),
	ZG("转岗培训", (byte) 2), 
	FG("复工培训", (byte) 3),
	ZGDQ("在岗期间定期培训", (byte) 4),
	SX("四新培训", (byte) 5),
	FS("放射培训", (byte) 6),
	YJJY("应急救援培训", (byte) 7),
	DSF("第三方培训", (byte) 8),
	ZYFZ("企业主要负责人培训", (byte) 9),
	ZYGL("职业卫生管理人员培训", (byte) 10),
	QT("其他培训", (byte) 11);

	private String name;
	private Byte code;

	private TrainPlanTypeEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}

	public String getName() {
		return name;
	}
	public Byte getCode() {
		return code;
	}
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (TrainPlanTypeEnum c : TrainPlanTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
}
