package cn.smarthse.modules.health.enums.train;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 线上或线下
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainOnLineEnum {

    online("线上", (byte) 2),
    offline("线下", (byte) 1),
    ;

    private String name;
    private Byte value;

    private TrainOnLineEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Byte value) {
        if (value == null) {
            return offline.getName();
        }
        for (TrainOnLineEnum c : TrainOnLineEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getValue() {
        return value;
    }

    public void setValue(Byte value) {
        this.value = value;
    }
}