package cn.smarthse.modules.health.enums.train;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训类型
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainHsTypeEnum {

    oneMonth("职业卫生", 1),
    twoMonth("安全", 2),
    ;

    private String name;
    private Integer value;

    private TrainHsTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }
        for (TrainHsTypeEnum c : TrainHsTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }
}