package cn.smarthse.modules.health.enums.train;

/**
 * 《监管系统时间区间类型枚举》
 * 
 * 
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi（肖奕)
 * @since 2018年4月16日-上午10:10:10
 */
public enum TimeRangeWillExpireEnum {
	
	oneWeek("一周", (byte) 1,-1,7),
	
	halfMonth("半个月", (byte) 2,7,15),
	
	oneMonth("一个月", (byte) 3,15,30),
		
	threeMonth("三个月", (byte) 4,30,90),	
	;

	
	// 成员变量
	private String name;
	private Byte value;
	private int min;
	private int max;
	// 构造方法
	private TimeRangeWillExpireEnum(String name, Byte value,int min,int max) {
		this.name = name;
		this.value = value;
		this.min = min;
		this.max = max;
	}
	
	public static TimeRangeWillExpireEnum getEnumByValue(Byte value) {
		if (value == null) {
			return null;
		}
		for (TimeRangeWillExpireEnum c : TimeRangeWillExpireEnum.values()) {
			if (c.getValue().byteValue()==value) {
				return c;
			}
		}
		return null;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte value) {
		this.value = value;
	}

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}
	
}
