package cn.smarthse.modules.health.enums.thirdtime;

import cn.smarthse.common.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 《项目性质》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017年7月12日-下午6:20:35
 */
public enum TsProjectTypeEnum {
	NEW((byte)1,"新建"),
	EXTEND((byte)2,"扩建"),
	REBUILD((byte)3,"改建"),
	IMPORT((byte)4,"技术引进"),
	REMOULD((byte)5,"技术改造"),
	;
	
	/**
	 * 项目性质编码
	 */
	private Byte code;
	/**
	 * 项目性质
	 */
	private String name;
	private TsProjectTypeEnum(Byte code,String name) {
		this.code = code;
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public static List<Map<String,Object>> getAllValues() {
		TsProjectTypeEnum[] tss = TsProjectTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(TsProjectTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Byte code) {
		if(code==null) return "";
		TsProjectTypeEnum[] tss = TsProjectTypeEnum.values();
		for(TsProjectTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	public static Byte getCodeByName(String name) {
		if(StringUtils.isBlank(name)) return null;
		TsProjectTypeEnum[] tss = TsProjectTypeEnum.values();
		for(TsProjectTypeEnum ts : tss) {
			if(ts.getName().equals(name)) {
				return ts.getCode();
			}
		}
		return null;
	}
	
}
