package cn.smarthse.modules.health.enums.thirdtime;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/4/28 18:00
 */
@Getter
public enum TsProjectSimpleStatusEnum {
    // 状态（0-草稿 1-待审核 2-退回 3-已审核 4-无需审核）
    DRAFT((byte) 0, "草稿"),
    AUDIT((byte) 1, "待审核"),
    BACK((byte) 2, "退回"),
    AUDITED((byte) 3, "已审核"),
    NO_NEED_AUDITED((byte) 4, "无需审核"),
    CLOSED((byte) 5, "已关闭"),
    PROJECT_MANDATORY_ANNUAL_UPDATE((byte) 7, "进行中项目强制年度更新"), // 2025年4月1日浙里卫企需求，状态【进行中项目强制年度更新】
    ;

    private Byte code;
    private String name;

    TsProjectSimpleStatusEnum(Byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public static TsProjectSimpleStatusEnum getEnum(Byte code) {
        return Arrays.stream(TsProjectSimpleStatusEnum.values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst().orElse(null);
    }
}
