package cn.smarthse.modules.health.enums.thirdtime;

import java.util.Arrays;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/4/28 18:00
 */
public enum TsProjectSimpleStateEnum {
    /**
     * 未进行至此流程，未开展， 进行中，已开展
     * 解释一下:
     * 未进行至此：要做这个，但是还没做到这个阶段
     * 未开展：确定已经是没做这个了
     */
    NOT_START((byte) 1, "未开展"),
    NOT_YET((byte) 2, "未进行至此"),
    ING((byte) 3, "进行中"),
    FINISH((byte) 4, "已开展"),
    ;

    private Byte code;
    private String name;

    TsProjectSimpleStateEnum(Byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public Byte getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static TsProjectSimpleStateEnum getEnum(Byte code) {
        return Arrays.stream(TsProjectSimpleStateEnum.values())
                .filter(e -> Objects.equals(e.getCode(), code))
                .findFirst()
                .orElse(null);
    }
}
