package cn.smarthse.modules.health.enums.thirdtime;

import java.util.Arrays;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/4/28 18:00
 */
public enum TsProjectSimpleRelatedEnum {
    NULL(null,"无"),
    WAIT_RELATED((byte)0,"待关联"),
    RELATED((byte)1,"已关联"),
    ;

    private Byte code;
    private String name;

    TsProjectSimpleRelatedEnum(Byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public Byte getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static TsProjectSimpleRelatedEnum getEnum(Byte code) {
        return Arrays.stream(TsProjectSimpleRelatedEnum.values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst().orElse(null);
    }
}
