package cn.smarthse.modules.health.enums.thirdtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

/**
 * 
 * 《项目性质》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017年7月12日-下午6:20:35
 */
public enum TsProjectPhraseEnum {
	START((byte)1,"立项"),
	STUDY((byte)2,"可研"),
	DESIGN((byte)3,"设计"),
	BUILD((byte)4,"施工"),
	DEBUG((byte)5,"试运行"),
	FINISH((byte)6,"项目完成"),
	;
	
	/**
	 * 项目性质编码
	 */
	private Byte code;
	/**
	 * 项目性质
	 */
	private String name;
	private TsProjectPhraseEnum(Byte code,String name) {
		this.code = code;
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public static List<Map<String,Object>> getAllValues() {
		return getAllValues(null);
	}
	public static List<Map<String,Object>> getAllValues(Predicate<TsProjectPhraseEnum> p) {
		TsProjectPhraseEnum[] tsp = TsProjectPhraseEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(TsProjectPhraseEnum ts : tsp) {
			if (p==null || p.test(ts)) {
				Map<String,Object> data = new HashMap<String,Object>();
				data.put("code", ts.getCode());
				data.put("name", ts.getName());
				list.add(data);
			}

		}
		return list;
	}
	
}
