package cn.smarthse.modules.health.enums.thirdparty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 第三方 企业类型与证书关联关系枚举
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017年6月20日-下午6:49:08
 */
public enum TpCompanyTypeEnum {
//	OTHER_ORG((byte)0,"其他", new String[]{"营业执照","组织机构代码证"}),
	
	//体检机构
	PHY_ORG((byte)1,"体检机构", new String[]{"营业执照","资质证书","组织机构代码证"}),
	//培训机构
	TRAIN_ORG((byte)2,"培训机构", new String[]{"营业执照","资质证书","组织机构代码证"}),
	//设计机构
	DESIGN_ORG((byte)3,"设计单位", new String[]{"营业执照","资质证书","组织机构代码证"}),
	//监理机构
	SUPERVISION_ORG((byte)4,"监理单位", new String[]{"营业执照","资质证书","组织机构代码证"}),
	
	//评价与检测机构
	EVALUATION_CHECK_ORG((byte)5,"评价与检测机构", new String[]{"营业执照","资质证书","组织机构代码证","计量认证证书"}),
	
	SUPPLY_ORG((byte)6,"供货商", new String[]{"营业执照","经营许可证","组织机构代码证"}),
//	//设备物资供货单位
//	DEVICE_SUPPLY_ORG((byte)6,"设备物资供货单位", new String[]{"营业执照","经营许可证","组织机构代码证"}),
////	设备物资生产单位
//	DEVICE_MAKING_ORG((byte)7,"设备物资生产单位", new String[]{"营业执照","经营许可证","组织机构代码证"}),
////	设备物资安装单位
//	DEVICE_INSTALL_ORG((byte)8,"设备物资安装单位", new String[]{"营业执照","经营许可证","组织机构代码证"}),
////	物料供货单位
//	MATTER_SUPPLY_ORG((byte)9,"物料供货单位", new String[]{"营业执照","经营许可证","组织机构代码证"}),
////	物料生产单位
//	MATTER_MAKING_ORG((byte)10,"物料生产单位", new String[]{"营业执照","经营许可证","组织机构代码证"}),
//	
	//施工单位
	CONSTRUCT((byte)11,"施工单位", new String[]{"营业执照","安全生产许可证","施工资质","组织机构代码证"})
	;
	/**
	 * 企业类型编号
	 */
	private Byte id;
	/**
	 * 企业类型名
	 */
	private String name;
	/**
	 * 企业类型对应有哪些必填证书
	 */
	private String[] certifis;
	
	private TpCompanyTypeEnum(Byte id,String name,String[] certifis) {
		this.id = id;
		this.name = name;
		this.certifis = certifis;
	}
	/**
	 * 
	 * 
	 * @Comments:  根据企业类型编号 获取该企业类型有哪些企业证书
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月21日-上午10:05:35
	 * @param id
	 * @return
	 */
	public static String[] getCertifisById(Byte id) {
		TpCompanyTypeEnum[] ts = TpCompanyTypeEnum.values();
		for(TpCompanyTypeEnum t:ts) {
			if(t.getId().equals(id)) {
				return t.getCertifis();
			}
		}
		return null;
	}
	/**
	 * 
	 * 
	 * @Comments:   根据企业类型编号 获取该企业类型名
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月21日-上午10:06:03
	 * @param id
	 * @return
	 */
	public static String getTypeNameById(Byte id) {
		if(id==null) return "";
		TpCompanyTypeEnum[] ts = TpCompanyTypeEnum.values();
		for(TpCompanyTypeEnum t:ts) {
			if(t.getId().equals(id)) {
				return t.getName();
			}
		}
		return "";
	}
	
	public static Byte getTypeByName(String name) {
		TpCompanyTypeEnum[] ts = TpCompanyTypeEnum.values();
		for(TpCompanyTypeEnum t:ts) {
			if(t.getName().equals(name)) {
				return t.getId();
			}
		}
		return 0;
	}
	
	public static List<Map<String,Object>> getAllNameId() {
		TpCompanyTypeEnum[] ts = TpCompanyTypeEnum.values();
		List<Map<String,Object>> companyTypeData= new ArrayList<Map<String,Object>>();
		for(TpCompanyTypeEnum t:ts) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("id", t.getId());
			data.put("name", t.getName());
			companyTypeData.add(data);
		}
		return companyTypeData;
	}

	public Byte getId() {
		return id;
	}

	public void setId(Byte id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String[] getCertifis() {
		return certifis;
	}

	public void setCertifis(String[] certifis) {
		this.certifis = certifis;
	}
	
//	public static void main(String[] args) {
//		TpCompanyTypeEnum[] ts = TpCompanyTypeEnum.values();
//		for(TpCompanyTypeEnum t:ts) {
//			System.out.println(t.name);
//		}
//
//		System.out.println(TpCompanyTypeEnum.valueOf("CONSTRUCT").getName());;
//	}
}
