package cn.smarthse.modules.health.enums.syslegal;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《法律法规类别enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.10.2>
 * @Comments:  <法律法规>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysLegalTypeEnum {

	
	type1("法律",1),
	
	type2("行政法规",2),
	
	type3("部门规章",3),
	
	type4("规范性文件",4),
	
	type5("地方政府规章",5),
	
	type6("国家标准",6),
	
	type7("行业标准",7),
	
	type8("地方标准",8),
	
	type9("其他",9),
	
	type10("行业推荐标准",10),

	type11("解读",11),
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private SysLegalTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (SysLegalTypeEnum c : SysLegalTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
