package cn.smarthse.modules.health.enums.syslegal;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《法律法规状态enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.10.2>
 * @Comments:  <法律法规>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysLegalStatusEnum {

	
	status1("现行",1),
	
	status2("作废",2),
	
	status3("即将实施",3),
	
	status4("废止",4),
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private SysLegalStatusEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (SysLegalStatusEnum c : SysLegalStatusEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
