package cn.smarthse.modules.health.enums.sysParam;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《系统参数表分组查询enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-6-15-上午9:59:22
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysParamGroupEnum {
	/**
	 * 企业登记注册类型
	 */
	register_type("企业登记注册类型","registration_type"),
	/**
	 * 国民经济行业分类
	 */
	national_econ_type("国民经济行业分类","industrial_classification"),
	/**
	 * 企业规模
	 */
	company_size("企业规模","enterprise_scale"),
	/**
	 * 辅助用室
	 */
	assist_room("辅助用室","auxiliary_room"),
	/**
	 * 建筑物纵轴方向
	 */
	building_long_direction("建筑物纵轴方向","construction_long_direction"),
	/**
	 * 建构筑物类别
	 */
	building_type("建构筑物类别","construction_type"),
	/**
	 * 专兼职类型
	 */
	full_part_time_type("专兼职类型","full_part_time_type"),
	/**
	 * 物料状态
	 */
	material_state("物料状态","material_state"),
	/**
	 * 性别
	 */
	sex("性别","gender"),
	/**
	 * 婚姻状况
	 */
	marital_status("婚姻状况","marriage_status"),
	/**
	 * 学历
	 */
	educ_background("学历","educ_background"),
	/**
	 * 职业照射职业分类
	 */
	occup_exposure_workingtype("职业照射职业分类","occup_exposure_workingtype"),
	/**
	 * 特种作业类型
	 */
	spec_operation_type("特种作业类型","spec_operation_type"),
	/**
	 * 特殊作业类型
	 */
	spec_working_type("特殊作业类型","spec_work_type"),
	/**
	 * 个人证书类别
	 */
	pers_cert_type("个人证书类别","pers_cert_type"),
	/**
	 * 岗位状态
	 */
	job_status("岗位状态","job_status"),
	/**
	 * 离/转岗类型
	 */
	job_ex_type("离/转岗类型","job_change_type"),
	/**
	 * 体检情况
	 */
	health_exam_state("体检情况","phys_exam_state"),
	/**
	 * 教育培训情况
	 */
	train_state("教育培训情况","train_state"),
	/**
	 * 合同告知情况
	 */
	contract_informed_state("合同告知情况","contract_informed_state"),
	
	/**
	 * 物料类别
	 */
	material_type("物料类别","material_type"),
	/**
	 * 防护设施分类
	 */
	device_type("防护设施分类","protect_facilities_category"),
	/**
	 * 层数
	 */
	layer_count("层数","layer_count"),
	/**
	 * 特种设备类型
	 */
	spec_equip_category("特种设备类型","spec_equip_category"),
	/**
	 * 放射设备类型
	 */
	radio_apparatus_type("放射设备类型","radio_apparatus_type"),
	/**
	 * 核素名称
	 */	
	radioisotope_name("核素名称","radioisotope_name"),
	/**
	 * 放射源类型
	 */
	radioisotope_type("放射源类型","radioisotope_type"),
	/**
	 * 射线装置类型
	 */
	radio_emit_device_type("射线装置类型","radio_emit_device_type"),
	/**
	 * 源强单位
	 */
	radio_strength_unit("源强单位","radio_strength_unit"),
	/**
	 * 计量单位
	 */
	material_unit("计量单位","material_unit"),
	/**
	 * 危险类别
	 */
	hazard_category("危险类别","hazard_category"),
	/**
	 * 包装类别
	 */
	packaging_groups("包装类别","packaging_groups"),
	/**
	 * 物料使用状态
	 */
	material_use_state("物料使用状态","material_use_state"),
	/**
	 * 物料生产状态
	 */
	material_production_state("物料生产状态","material_production_state"),
	/**
	 * 警示标识分类
	 */
	warnmark_type("警示标识分类","warnmark_type"),
	/**
	 * 职业卫生管理制度类型
	 */
	managsys_occuptype("职业卫生管理制度类型","Type_occupational_health_management_system"),
	/**
	 * 管理制度类别
	 */
	managsys_type("管理制度类别","managsys_type"),
	/**
	 * 法律法规标准类别
	 */
	Type_law_standard("法律法规标准类别","Type_law_standard"),
	/**
	 * 法律法规标准状态
	 */
	State_law_standard("法律法规标准状态","State_law_standard"),
	
	/**
	 * 公司管理制度类别
	 */
	Type_company_management_system("公司管理制度类别","Type_company_management_system"),
	/**
	 * 个体防护用品品类
	 */
	Type_PPE("个体防护用品品类","Type_PPE"),
	/**
	 * 设备状态
	 */
	equip_state("设备状态","equip_state"),
	/**
	 * 专业领域
	 */
	Area_Expertise("专业领域","Area_Expertise"),
	
	; 
	
	// 成员变量
	private String name;
	private String value;
	// 构造方法

	private SysParamGroupEnum(String name, String value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (SysParamGroupEnum c : SysParamGroupEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String index) {
		this.value = index;
	}
}
