package cn.smarthse.modules.health.enums.sys.coreWork;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TodlistInfoTypeEnum {

	/**
	 * 点击【新增】开始一项新的职业病危害因素检测工作
	 */
	harmfactorTest_add("点击【新增】开始一项新的职业病危害因素检测工作",(byte) 0),
	/**
	 * 进行中的职业病危害因素检测工作（X）
	 */
	harmfactorTest_doing("进行中的职业病危害因素检测工作（X）",(byte) 1),
	/**
	 * 职业病危害因素检测有不符合项，待整改
	 */
	harmfactorTest_hasInconformity("职业病危害因素检测有不符合项，待整改",(byte) 2),
	
	/**
	 * 已有不符合项整改完成，待检测验证（X）
	 */	
	harmfactorTest_reCheck("已有不符合项整改完成，待检测验证（X）",(byte) 3),
	
	/**
	 * 职业病危害因素检测与评价结果待上报登记
	 */
	harmfactorTest_report("职业病危害因素检测与评价结果待上报登记",(byte) 4),
	
	/**
	 * 距离上次检测已1年，是否进行定期检测？
	 */
	harmfactorTest_oneYearCheck("距离上次检测已1年，是否进行定期检测？",(byte)5),
	
	/**
	 * 距离上次评价已3年，是否进行职业病危害现状评价？
	 */
	harmfactorTest_threeYearCheck("距离上次评价已3年，是否进行职业病危害现状评价？",(byte)6),
	
	/**
	 * 发生职业病危害事故，是否进行职业病危害现状评价？（1）
	 */
	harmfactorTest_hasAccident("发生职业病危害事故，是否进行职业病危害现状评价？（X）",(byte)7),
	
	/**
	 * 【XX】项目进入试运行阶段，是否进行职业病危害控制效果评价？
	 */
	harmfactorTest_projectRun("【XXX】项目进入试运行阶段，是否进行职业病危害控制效果评价？",(byte)8),
	
	/**
	 * 请点击【新增】开始一项新的职业健康检查工作
	 */
	healthCheck_add("请点击【新增】开始一项新的职业健康检查工作",(byte)9),
	
	/**
	 * 进行中的职业健康检查工作（1）
	 */
	healthCheck_doing("进行中的职业健康检查工作（X）",(byte)10),
	
	/**
	 * 体检结果有异常人员，待处理（11）
	 */
	healthCheck_needDeal("体检结果有异常人员，待处理（X）",(byte)11),
	
	/**
	 * 体检结果异常，待复查人员（11）
	 */
	healthCheck_needRecheck("体检结果异常，待复查人员（X）",(byte)12),
	
	/**
	 * 体检结果异常，待转岗人员（11）
	 */
	healthCheck_needChangePost("体检结果异常，待转岗人员（X）",(byte)13),
	
	/**
	 * 体检结果异常，待职业病诊断人员（11）
	 */
	healthCheck_needDiagnosis("体检结果异常，待职业病诊断人员（X）",(byte)14),
	
	/**
	 * 发现（疑似）职业病人，待上报（1）
	 */
	healthCheck_needReport("发现（疑似）职业病人，待上报（X）",(byte)15),
	
	/**
	 * 今年还未进行过在岗期间职业健康检查，是否开始进行？
	 */
	healthCheck_thisYear("今年还未进行过在岗期间职业健康检查，是否开始进行？",(byte)16),
	
	/**
	 * 企业发生职业病危害事故，是否登记应急健康检查信息？（1）
	 */
	healthCheck_hasAccident("企业发生职业病危害事故，是否登记应急健康检查信息？（X）",(byte)17),
	
	/**
	 * 【XX】项目已进入试运行阶段，需组织从事接触职业病危害作业的劳动者进行上岗前职业健康检查
	 */
	healthCheck_projectRun("【XXX】项目已进入试运行阶段，需组织从事接触职业病危害作业的劳动者进行上岗前职业健康检查",(byte)18),
	
	/**
	 * 请点击【新增】开始一项新的教育培训工作
	 */
	trainPlan_add("请点击【新增】开始一项新的教育培训工作",(byte)19),
	
	/**
	 * 进行中的教育培训工作（1）
	 */
	trainPlan_doing("进行中的教育培训工作（X）",(byte)20),
	
	/**
	 * 进行中的年度培训总结工作（1）
	 */
	trainPlan_yearTraindoing("进行中的年度培训总结工作（X）",(byte)21),
	
	/**
	 * 今年还未进行过年度培训总结，是否进行？
	 */
	trainPlan_thisYear("今年还未进行过年度培训总结，是否进行？",(byte)22),
	
	/**
	 * 培训相关资料管理
	 */
	trainPlan_fileManage("培训相关资料管理",(byte)23),
	
	/**
	 * 企业发生职业病危害事故，是否进行教育培训？（1）
	 */
	trainPlan_hasAccident("企业发生职业病危害事故，是否进行教育培训？（X）",(byte)24),
	
	/**
	 * 今年还未进行过职业卫生培训，是否进行？
	 */
	trainPlan_thisYearOcc("今年还未进行过职业卫生培训，是否进行？",(byte)25),
	
	/**
	 * 【XX】项目已进入试运行阶段，需组织劳动者进行上岗前的职业卫生培训
	 */
	trainPlan_projectRun("【XXX】项目已进入试运行阶段，需组织劳动者进行上岗前的职业卫生培训",(byte)26),
	
	/**
	 * 请点击【新增】开始一项新的职业病危害项目申报工作
	 */
	harmfactorDeclare_add("请点击【新增】开始一项新的职业病危害项目申报工作",(byte)27),
	
	/**
	 * 查看职业病危害项目申报参考数据
	 */
	harmfactorDeclare_referenceData("查看职业病危害项目申报参考数据",(byte)28),
	
	/**
	 * 进行中的职业病危害项目申报工作（1）
	 */
	harmfactorDeclare_doing("进行中的职业病危害项目申报工作（X）",(byte)29),
	
	/**
	 * 【XX】项目已完成，是否进行职业病危害申报？
	 */
	harmfactorDeclare_projectRun("【XXX】项目已完成，是否进行职业病危害申报？",(byte)30),
	
	/**
	 * 请点击【新增】开始一项新的现场检查工作
	 */
	occupationHygieneInspection_add("请点击【新增】开始一项新的现场检查工作",(byte)31),
	
	/**
	 * 进行中的现场检查工作（   ）
	 */
	occupationHygieneInspection_doing("进行中的现场检查工作（X）",(byte)32),
	
	/**
	 * 检查表管理
	 */
	occupationHygieneInspection_table("检查表管理",(byte)33),
	
	/**
	 * 请点击【新增】开始一项新的整改工作
	 */
	reform_add("请点击【新增】开始一项新的整改工作",(byte)34),
	
	/**
	 * 进行中的整改工作（   ）
	 */
	reform_doing("进行中的整改工作（X）",(byte)35),
	
	/**
	 * 请点击【新增】开始一项新的三同时工作
	 */
	threeSimultaneity_add("请点击【新增】开始一项新的三同时工作",(byte)36),
	
	/**
	 * 进行中的三同时工作（   ）
	 */
	threeSimultaneity_doing("进行中的三同时工作（X）",(byte)37),
	
	/**
	 * 请点击【新增-采购信息】开始一项新的防护用品采购信息登记
	 */
	personalProtectionEquipment_addPurchase("请点击【新增-采购信息】开始一项新的防护用品采购信息登记",(byte)38),
	
	/**
	 * 请点击【新增-发放信息】开始一项新的防护用品发放信息登记
	 */
	personalProtectionEquipment_addProvide("请点击【新增-发放信息】开始一项新的防护用品发放信息登记",(byte)39),
	
	/**
	 * 防护用品配备标准维护
	 */
	personalProtectionEquipment_standard("防护用品配备标准维护",(byte)40),
	
	/**
	 * 进行中的防护用品采购信息登记（1 ）
	 */
	personalProtectionEquipment_doingPruchase("进行中的防护用品采购信息登记（X ）",(byte)41),
	
	/**
	 * 进行中的防护用品发放信息登记（ 1  ）
	 */
	personalProtectionEquipment_doingProvide("进行中的防护用品发放信息登记（X）",(byte)42),
	
	/**
	 * 【XX项目】为职业病危害项目，需为劳动者提供符合要求的个人职业病防护用品
	 */
	personalProtectionEquipment_projectRun("【XXX项目】为职业病危害项目，需为劳动者提供符合要求的个人职业病防护用品",(byte)43),
	
	/**
	 * 距离上次防护用品采购信息登记已半年，是否进行防护用品采购信息登记？
	 */
	personalProtectionEquipment_halfYearPruchase("距离上次防护用品采购信息登记已半年，是否进行防护用品采购信息登记？",(byte)44),
	
	/**
	 * 距离上次防护用品发放信息登记已半年，是否进行防护用品发放信息登记？
	 */
	personalProtectionEquipment_halfYearProvide("距离上次防护用品发放信息登记已半年，是否进行防护用品发放信息登记？",(byte)45),
	
	/**
	 * 【XX岗位】接触的危害因素有变更，是否维护防护用品配备标准
	 */
	personalProtectionEquipment_post("【XXX岗位】接触的危害因素有变更，是否维护防护用品配备标准",(byte)46),
	
	/**
	 * 请点击【新增】添加防护设施维护信息
	 */
	protectionEquipmentMaintenance_add("请点击【新增】添加防护设施维护信息",(byte)47),
	
	/**
	 * 进行中的防护设施维护信息登记（1）
	 */
	protectionEquipmentMaintenance_doing("进行中的防护设施维护信息登记（X）",(byte)48),
	
	/**
	 * 距离上次防护设施维护已1年，是否登记维护信息？
	 */
	protectionEquipmentMaintenance_oneYear("距离上次防护设施维护已1年，是否登记维护信息？",(byte)49),
	
	/**
	 * 请点击【新增】添加警示标识维护信息
	 */
	WarningSigns_add("请点击【新增】添加警示标识维护信息",(byte)50),
	
	/**
	 * 警示标识信息维护
	 */
	WarningSigns_maintenance("警示标识信息维护",(byte)51),
	
	/**
	 * XXX建设项目已完成，需设置警示标识
	 */
	WarningSigns_projectRun("【XXX】建设项目已完成，需设置警示标识",(byte)52),
	
	/**
	 * 进行中的警示标识维护信息登记（1 ）
	 */
	WarningSigns_doing("进行中的警示标识维护信息登记（X ）",(byte)53),
	
	/**
	 * 距离上次警示标识维护已1年，是否登记维护信息？
	 */
	WarningSigns_oneYear("距离上次警示标识维护已1年，是否登记维护信息？",(byte)54),
	
	/**
	 * 【XX区域】存在的危害因素有变更，是否更新警示标识信息？
	 */
	WarningSigns_area("【XXX区域】存在的危害因素有变更，是否更新警示标识信息？",(byte)55),
	
	/**
	 * 进行中的职业病危害告知工作（11）
	 */
	informManagement_doing("进行中的职业病危害告知工作（X）",(byte)56),
	
	/**
	 * 当前岗位无职业病危害告知的人员（11）
	 */
	informManagement_postNoInform("当前岗位无职业病危害告知的人员（X）",(byte)57),
	
	/**
	 * 合同告知模板管理
	 */
	informManagement_template("合同告知模板管理",(byte)58),
	
	/**
	 * 请点击【新增】开始一项新的应急演练工作
	 */
	emeManagement_add("请点击【新增】开始一项新的应急演练工作",(byte)59),
	
	/**
	 * 应急机构与队伍信息维护
	 */
	emeManagement_maintenance("应急机构与队伍信息维护",(byte)60),
	
	/**
	 * 进行中的应急演练工作（   ）
	 */
	emeManagement_doing("进行中的应急演练工作（X）",(byte)61),
	
	/**
	 * 距离上次应急救援演练已1年，是否进行应急救援演练？
	 */
	emeManagement_oneYear("距离上次应急救援演练已1年，是否进行应急救援演练？",(byte)62),
	
	/**
	 * 请点击【新增】登记一次事故信息
	 */
	accidentManement_add("请点击【新增】登记一次事故信息",(byte)63),
	
	/**
	 * 进行中的事故信息登记（1）
	 */
	accidentManement_doing("进行中的事故信息登记（X）",(byte)64),
	
	/**
	 * 请点击【新增】开始一项新的职业病防治工作年度计划
	 */
	yearPlan_add("请点击【新增】开始一项新的职业病防治工作年度计划",(byte)65),
	
	/**
	 * 进行中的职业病防治年度工作计划（1）
	 */
	yearPlan_doing("进行中的职业病防治年度工作计划（X）",(byte)66),
	
	/**
	 * 有职业病防治年度工作计划待总结（1）
	 */
	yearPlan_summary("有职业病防治年度工作计划待总结（X）",(byte)67),
	
	/**
	 * 距离上次职业病防治年度计划已1年，是否制定新的年度计划？
	 */
	yearPlan_oneYear("距离上次职业病防治年度计划已1年，是否制定新的年度计划？",(byte)68),
	
	/**
	 * 请点击【新增】开始一项新的个人剂量监测工作
	 */
	personalDoseMonitoring_add("请点击【新增】开始一项新的个人剂量监测工作",(byte)69),
	
	/**
	 * 进行中的个人剂量监测工作（1）
	 */
	personalDoseMonitoring_doing("进行中的个人剂量监测工作（X）",(byte)70),
	
	/**
	 * 大剂量调查登记
	 */
	personalDoseMonitoring_register("大剂量调查登记",(byte)71),
	
	/**
	 * 距离上次监测已3个月，是否进行个人剂量监测
	 */
	personalDoseMonitoring_threeMonth("距离上次监测已3个月，是否进行个人剂量监测",(byte)72),
	
	/**
	 * 企业主要负责人的职业卫生管理培训合格证书还未登记，是否登记？
	 */
	staffCertificate_leader("企业主要负责人的职业卫生管理培训合格证书还未登记，是否登记？",(byte)73),
	
	/**
	 * 企业职业卫生管理人员的职业卫生管理培训合格证书还未登记，是否登记？
	 */
	staffCertificate_manager("企业职业卫生管理人员的职业卫生管理培训合格证书还未登记，是否登记？",(byte)74),
	
	/**
	 * 主要负责人的安全培训合格证书还未登记，是否登记？
	 */
	staffCertificate_director_safe_train("主要负责人的安全培训合格证书还未登记，是否登记？",(byte)82),
	
	/**
	 * 分管安全负责人的安全培训合格证书还未登记，是否登记？
	 */
	staffCertificate_collaborator_safe_train("分管安全负责人的安全培训合格证书还未登记，是否登记？",(byte)83),
	
	/**
	 * 安全生产管理人员的安全培训合格证书还未登记，是否登记？
	 */
	staffCertificate_safe_produce_train("安全生产管理人员的安全培训合格证书还未登记，是否登记？",(byte)84),
	
	/**
	 * 证书已到期的人员（11）---------------------------好像没用到？？？？
	 */
	staffCertificate_expire("证书已到期的人员（X）",(byte)75),
	
	/**
	 * 距离上次安全现状评价已经3年，是否进行安全现状评价？
	 */
	evaluate_last_safe("距离上次安全现状评价已经3年，是否进行安全现状评价？",(byte)76),
	
	/**
	 * 距离上次职业病危害现状评价已经3年，是否进行职业病危害现状评价？
	 */
	evaluate_last_harmFactor("距离上次职业病危害现状评价已经3年，是否进行职业病危害现状评价？",(byte)77),
	
	/**
	 * 【XX】项目已进入可研阶段，是否登记该项目安全预评价信息？
	 */
	evaluate_feasibility_study_safe("【XX】项目已进入可研阶段，是否登记该项目安全预评价信息？",(byte)78),
	
	/**
	 * 【XX】项目已进入可研阶段，是否登记该项目职业病危害预评价信息？
	 */
	evaluate_feasibility_study_harmFactor("【XX】项目已进入可研阶段，是否登记该项目职业病危害预评价信息？",(byte)79),
	
	/**
	 * 【XXX】项目进入试运行阶段，是否登记该项目安全验收评价信息？
	 */
	evaluate_projectRun_safe("【XXX】项目进入试运行阶段，是否登记该项目安全验收评价信息？",(byte)80),
	
	/**
	 * 【XXX】项目进入试运行阶段，是否登记该项目职业病危害控制效果评价信息？
	 */
	evaluate_projectRun_harmFactor("【XXX】项目进入试运行阶段，是否登记该项目职业病危害控制效果评价信息？",(byte)81),
	
	/**
	 * XX项目检测已完成，是否关联职业病危害因素？
	 */
	harmfactorManage_harmfactorTest("XX项目检测已完成，是否关联职业病危害因素？",(byte)85),
	
	/**
	 * XX工为新增工种，是否进行职业病危害因素信息登记？
	 */
	harmfactorManage_companyWorkType("XX工为新增工种，是否进行职业病危害因素信息登记？",(byte)86),
	
	/**
	 * [XX区域]设备/原辅物料有变更，是否更新职业病危害因素信息
	 */
	harmfactorManage_companyArea("[XX区域]设备/原辅物料有变更，是否更新职业病危害因素信息",(byte)87),

	harmfactor_noCheck("再过三个月，距离上次检测已超过1年，请及时安排职业病危害因素检测，并提醒技术服务机构上报结果",(byte)88),

    harmfactorTest_threeYearNoCheck("再过三个月，距离上次检测已超过3年，请及时安排职业病危害因素检测，并提醒技术服务机构上报结果",(byte)89),

	harmFactor_noDeclare("今年尚未进行职业病危害项目申报，请及时进行职业病危害因素检测和职业病危害项目申报",(byte)90),

	harmfactor_Check_overdate("距离上次检测已超过1年，请及时安排职业病危害因素检测，并提醒技术服务机构上报结果",(byte)91),

	/**
	 * 最大90了。
	 */
	;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private TodlistInfoTypeEnum(String name, Byte value) {
			this.name = name;
			this.value = value;
		}
		
		/**
		 * 是否永远忽略
		 * 
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author Horsy(何世壹) [hsy@smarthse.cn]
		 * @since 2017年8月30日-下午3:41:58
		 * @param type 提示类型
		 * @return
		 */
		public static boolean isIgnoreForever(TodlistInfoTypeEnum type){
			if(type.getValue().equals(TodlistInfoTypeEnum.staffCertificate_leader.getValue())){
				return true;
			}
			if(type.getValue().equals(TodlistInfoTypeEnum.staffCertificate_manager.getValue())){
				return true;
			}
			
			return false;
		}
		
		public static boolean isIgnoreNotBusiness(TodlistInfoTypeEnum todolistType){
			
			if(TodlistInfoTypeEnum.staffCertificate_leader.getValue().equals(todolistType.getValue())){
				//企业主要负责人的职业卫生管理培训合格证书还未登记，是否登记？
				return true;
			} else if(TodlistInfoTypeEnum.staffCertificate_manager.getValue().equals(todolistType.getValue())){
				//企业职业卫生管理人员的职业卫生管理培训合格证书还未登记，是否登记？
				return true;
			} else if(TodlistInfoTypeEnum.staffCertificate_director_safe_train.getValue().equals(todolistType.getValue())){
				//主要负责人的安全培训合格证书还未登记，是否登记？
				return true;
			} else if(TodlistInfoTypeEnum.staffCertificate_collaborator_safe_train.getValue().equals(todolistType.getValue())){
				//分管安全负责人的安全培训合格证书还未登记，是否登记？
				return true;
			} else if(TodlistInfoTypeEnum.staffCertificate_safe_produce_train.getValue().equals(todolistType.getValue())){
				//安全生产管理人员的安全培训合格证书还未登记，是否登记？
				return true;
			} else if(TodlistInfoTypeEnum.personalDoseMonitoring_threeMonth.getValue().equals(todolistType.getValue())){
				//距离上次监测已3个月，是否进行个人剂量监测
				return true;
			} else if(TodlistInfoTypeEnum.yearPlan_oneYear.getValue().equals(todolistType.getValue())){
				//距离上次职业病防治年度计划已1年，是否制定新的年度计划？
				return true;
			} else if(TodlistInfoTypeEnum.emeManagement_oneYear.getValue().equals(todolistType.getValue())){
				//距离上次应急救援演练已1年，是否进行应急救援演练？
				return true;
			} else if(TodlistInfoTypeEnum.WarningSigns_oneYear.getValue().equals(todolistType.getValue())){
				//距离上次警示标识维护已1年，是否登记维护信息？
				return true;
			} else if(TodlistInfoTypeEnum.protectionEquipmentMaintenance_oneYear.getValue().equals(todolistType.getValue())){
				//距离上次防护设施维护已1年，是否登记维护信息？
				return true;
			} else if(TodlistInfoTypeEnum.personalProtectionEquipment_halfYearProvide.getValue().equals(todolistType.getValue())){
				//距离上次防护用品发放信息登记已半年，是否进行防护用品发放信息登记？
				return true;
			} else if(TodlistInfoTypeEnum.personalProtectionEquipment_halfYearPruchase.getValue().equals(todolistType.getValue())){
				//距离上次防护用品采购信息登记已半年，是否进行防护用品采购信息登记？
				return true;
			} else if(TodlistInfoTypeEnum.trainPlan_thisYearOcc.getValue().equals(todolistType.getValue())){
				//今年还未进行过职业卫生培训，是否进行？
				return true;
			} else if(TodlistInfoTypeEnum.trainPlan_thisYear.getValue().equals(todolistType.getValue())){
				//今年还未进行过年度培训总结，是否进行？
				return true;
			} else if(TodlistInfoTypeEnum.healthCheck_thisYear.getValue().equals(todolistType.getValue())){
				//今年还未进行过在岗期间职业健康检查，是否开始进行？
				return true;
			} else if(TodlistInfoTypeEnum.harmfactorTest_threeYearCheck.getValue().equals(todolistType.getValue())){
				//距离上次评价已3年，是否进行职业病危害现状评价？
				return true;
			} else if(TodlistInfoTypeEnum.harmfactorTest_oneYearCheck.getValue().equals(todolistType.getValue())){
				//距离上次检测已1年，是否进行定期检测？
				return true;
			}else if (TodlistInfoTypeEnum.evaluate_last_safe.getValue().equals(todolistType.getValue())){
				//距离上次安全现状评价已经3年，是否进行安全现状评价？
				return true;
			}else if (TodlistInfoTypeEnum.evaluate_last_harmFactor.getValue().equals(todolistType.getValue())){
				//距离上次职业病危害现状评价已经3年，是否进行职业病危害现状评价？
				return true;
			}else if (TodlistInfoTypeEnum.harmfactor_noCheck.getValue().equals(todolistType.getValue())){
				//距离上次检测已一年，请提醒技术服务机构上传结果
				return true;
			}else if(harmfactorTest_threeYearNoCheck.getValue().equals(todolistType.getValue())){
			    //距离上次检测已3年，请提醒技术服务机构上传结果
			    return true;
            }else if(harmFactor_noDeclare.getValue().equals(todolistType.getValue())){
				//今年尚未进行职业病危害项目申报，请及时进行职业病危害因素检测和职业病危害项目申报
				return true;
			}else if(harmfactor_Check_overdate.getValue().equals(todolistType.getValue())){
				return true;
			}
			return false;
		}
		
		public static Byte getThreeTimeStageByValue(Byte value){
			if(TodlistInfoTypeEnum.evaluate_feasibility_study_harmFactor.getValue().equals(value)
					|| TodlistInfoTypeEnum.evaluate_feasibility_study_safe.getValue().equals(value)){
				return TsProjectPhraseEnum.STUDY.getCode();
			}else if(TodlistInfoTypeEnum.evaluate_projectRun_harmFactor.getValue().equals(value)
					|| TodlistInfoTypeEnum.evaluate_projectRun_safe.getValue().equals(value)){
				return TsProjectPhraseEnum.DEBUG.getCode();
			}
			
			return null;
		}
		
		public static TodlistInfoTypeEnum getByValue(Byte value){
			if(value == null){
				return null;
			}
			for(TodlistInfoTypeEnum type : TodlistInfoTypeEnum.values()){
				if(type.getValue().equals(value)){
					return type;
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}
