package cn.smarthse.modules.health.enums.sys.coreWork;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CoreWorkEnum {


	/**
	 * 职业病危害因素检测
	 */
	harmfactorTest("职业病危害因素检测",(byte)1,true,1,"harmfactorTest",true),

	harmfactorNoCheck("职业病危害因素检测已超过一年未检测",(byte)1000,true,1000,"harmfactorNoCheck",true),

	/**
	 * 职业健康体检
	 */
	healthCheck("职业健康体检",(byte)2,true,2,"healthCheck",true),
	
	/**
	 * 教育培训
	 */
	trainPlan("教育培训",(byte)3,true,3,"trainPlan",true),
	
	/**
	 * 职业病危害项目申报
	 */
	harmfactorDeclare("职业病危害项目申报",(byte)4,true,4,"harmfactorDeclare",true),
	
	/**
	 * 隐患排查
	 */
	occupationHygieneInspection("隐患排查",(byte)5,false,5,"occupationHygieneInspection",true),
	
	/**
	 * 隐患治理
	 */
	reformManagement("隐患治理",(byte)6,false,6,"reform",true),
	
	/**
	 * “三同时”管理
	 */
	threeSimultaneityManagement("“三同时”管理",(byte)7,true,7,"threeSimultaneity",true),
	
	/**
	 * 个人防护用品管理
	 */
	personalProtectionEquipment("个人防护用品管理",(byte)8,true,8,"personalProtectionEquipment",true),
	
	/**
	 * 防护设施维护
	 */
	protectionEquipmentMaintenance("防护设施维护",(byte)9,true,9,"protectionEquipmentMaintenance",true),
	
	/**
	 * 警示标识管理
	 */
	WarningSigns("警示标识管理",(byte)10,false,10,"WarningSigns",true),
	
	/**
	 * 告知管理
	 */
	informManagement("告知管理",(byte)11,false,11,"informManagement",true),
	
	/**
	 * 应急管理
	 */
	emeManagement("应急管理",(byte)12,false,12,"emeManagement",true),
	
	/**
	 * 事故管理
	 */
	accidentManement("事故管理",(byte)13,false,13,"accidentManement",true),
	
	/**
	 * 人员证书管理
	 */
	staffCertificate("人员证书管理",(byte)14,false,14,"staffCertificate",true),
	
	/**
	 * 年度工作计划
	 */
	yearPlan("年度工作计划",(byte)15,false,15,"yearPlan",true),
	
	/**
	 * 个人剂量监测
	 */
	personalDoseMonitoring("个人剂量监测",(byte)16,false,16,"personalDoseMonitoring",true),
	
	
	/**
	 * 评价工作
	 */
	evaluate("评价工作",(byte)19,false,19,"evaluate",true),
	
	/**
	 * 职业病危害因素管理
	 */
	harmfactor("职业病危害因素管理",(byte)20,false,20,"harmfactor",true),
	
	/**
	 * 危害因素管理(岗位)
	 */
	harmfactorManagePost("危害因素管理(岗位)",(byte)17,false,17,"harmfactorManagePost",true),
	
	/**
	 * 危害因素管理(区域)
	 */
	harmfactorManageArea("危害因素管理(区域)",(byte)18,false,18,"harmfactorManageArea",true),

	/**
	 * 职业病诊断
	 */
	diseaser("职业病诊断",(byte)23,false,23,"diseaser",true),
	
	AllWork("所有的业务",(byte)99,false,99,"AllWork",false),
	
	/**********************非关键工作模块***************************/

	/**
	 * 区域
	 */
	companyArea("区域",(byte)21,false,21,"companyArea",false),
	
	/**
	 * 工种
	 */
	companyWorkType("工种",(byte)22,false,22,"companyWorkType",false),
	
	; 
	
	// 成员变量
	private String name;
	private String code;
	private Byte value;
	private Boolean isCoreWork;
	/**
	 * 是否默认显示
	 */
	private boolean isDefaultShow;
	
	/**
	 * 此属性暂时没用到
	 */
	@Deprecated
	private List<TodlistInfoTypeEnum> types = new ArrayList<TodlistInfoTypeEnum>();
	
	/**
	 * 排序
	 */
	private int order;
	// 构造方法

	private CoreWorkEnum(String name, Byte value,boolean isDefaultShow,int order,String code,Boolean isCoreWork) {
		this.name = name;
		this.value = value;
		this.isDefaultShow = isDefaultShow;
		this.order = order;
		this.code=code;
		this.isCoreWork=isCoreWork;
		for(TodlistInfoTypeEnum type :TodlistInfoTypeEnum.values()){
			if(type.name().startsWith(code+"_")){
				types.add(type);
			}
		}
		
	}
	// 普通方法
	public static String getName(Byte value) {
		if (value == null) {
			return null;
		}
		CoreWorkEnum core=getCoreWorkEnum(value);
		if(core !=null){
			return core.getName();
		}
		return null;
	}
	// 普通方法
	public static CoreWorkEnum getCoreWorkEnum(Byte value) {
		if (value == null) {
			return null;
		}
		for (CoreWorkEnum c : CoreWorkEnum.values()) {
			if (c.getValue().byteValue()==value) {
				return c;
			}
		}
		return null;
	}
	/**
	 * 获取三同时项目试运行的时候相关联的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:53:35
	 * @return
	 */
	public static List<CoreWorkEnum> getThreeSimultaneityProjectRunRelationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.harmfactorTest);
		list.add(CoreWorkEnum.healthCheck);
		list.add(CoreWorkEnum.trainPlan);
		list.add(CoreWorkEnum.personalProtectionEquipment);
		list.add(CoreWorkEnum.WarningSigns);
		list.add(CoreWorkEnum.evaluate);
		return list;
	}
	
	/**
	 * 获取三同时项目进入可研的时候相关联的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:53:35
	 * @return
	 */
	public static List<CoreWorkEnum> getThreeSimultaneityProjectStudyRelationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.evaluate);
		return list;
	}
	/**
	 * 三同时项目完成的时候关联的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:05:14
	 * @return
	 */
	public static List<CoreWorkEnum> getThreeSimultaneityCompleteRelationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.harmfactorDeclare);
		return list;
	}
	
	/**
	 * 整改完成相关联的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:13:54
	 * @return
	 */
	public static List<CoreWorkEnum> getReformRelationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.harmfactorTest);
		return list;
	}
	
	/**
	 * 岗位接触的危害因素相关的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:29:54
	 * @return
	 */
	public static List<CoreWorkEnum> getHarmfactorManagePostlationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.personalProtectionEquipment);
		return list;
	}
	
	/**
	 * @Comments:  <机构端上传了 评价信息， 企业端关键工作提示>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2019/9/3-11:00
	 * @param 
	 * @return java.util.List<cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum>
	*/
	public static List<CoreWorkEnum> getUploadedEvaluateByOrgan(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.evaluate);
		return list;
	}

	/**
	 * @Comments:  <机构端上传了 体检信息， 企业端关键工作提示>
	 * @author yanao
	 * @since 2019/10/8-11:00
	 * @param
	 * @return java.util.List<cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum>
	 */
	public static List<CoreWorkEnum> getUploadedCheckByOrgan(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.healthCheck);
		return list;
	}
	/**
	 * @Comments:  <机构端上传了 职业病人诊断信息， 企业端关键工作提示>
	 * @author yanao
	 * @since 2020/9/18-11:00
	 * @param
	 * @return java.util.List<cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum>
	 */
	public static List<CoreWorkEnum> getUploadedDiseaserByOrgan(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.diseaser);
		return list;
	}
	public static List<CoreWorkEnum> getHarmfactorManageArealationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.WarningSigns);
		return list;
	}
	public static List<CoreWorkEnum> getEvaluatelationModule(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.harmfactorTest);
		return list;
	}
	
	/**
	 * 事故上报，相关联的模块
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:11:22
	 * @return
	 */
	public static List<CoreWorkEnum> getAccidentRelationModel(){
		List<CoreWorkEnum> list = new ArrayList<CoreWorkEnum>();
		list.add(CoreWorkEnum.harmfactorTest);
		list.add(CoreWorkEnum.healthCheck);
		list.add(CoreWorkEnum.trainPlan);
		list.add(CoreWorkEnum.evaluate);
		return list;
	}
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte index) {
		this.value = index;
	}
	public boolean isDefaultShow() {
		return isDefaultShow;
	}
	public void setDefaultShow(boolean isDefaultShow) {
		this.isDefaultShow = isDefaultShow;
	}
	public int getOrder() {
		return order;
	}
	public void setOrder(int order) {
		this.order = order;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public List<TodlistInfoTypeEnum> getTypes() {
		return types;
	}
	public void setTypes(List<TodlistInfoTypeEnum> types) {
		this.types = types;
	}
	public Boolean getIsCoreWork() {
		return isCoreWork;
	}
	public void setIsCoreWork(Boolean isCoreWork) {
		this.isCoreWork = isCoreWork;
	}
	
	
}
