package cn.smarthse.modules.health.enums.sys.coreWork;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 业务事件
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月24日-上午11:19:45
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum BusinessEventEnum {

	/**
	 * 存草稿
	 * 影响：
	 * 点击【新增】开始一项新的职业病危害因素检测工作
	 * 进行中的职业病危害因素检测工作（1）
	 * 距离上次检测已1年，是否进行定期检测？
	 * 距离上次评价已3年，是否进行职业病危害现状评价？
	 */
	harmfactorTest_draff,
	
	/**
	 * 完成
	 * 影响：
	 * 点击【新增】开始一项新的职业病危害因素检测工作
	 * 进行中的职业病危害因素检测工作（1）
	 * 职业病危害因素检测与评价结果待上报登记
	 * 距离上次检测已1年，是否进行定期检测？
	 * 距离上次评价已3年，是否进行职业病危害现状评价？
	 * 【XX】项目进入试运行阶段，是否进行职业病危害控制效果评价？
	 */
	harmfactorTest_complete,
	
	/**
	 * 终止
	 *  影响：
	 *  进行中的职业病危害因素检测工作（1）
	 *  
	 */
	harmfactorTest_termination,
	
	/**
	 * 删除
	 * 影响：
	 * 点击【新增】开始一项新的职业病危害因素检测工作
	 * 进行中的职业病危害因素检测工作（1）
	 * 
	 */
	harmfactorTest_delete,
	
	/**
	 * 复测完成
	 * 影响：
	 * harmfactorTest_complete
	 * 已有不符合项整改完成，待检测验证（1）
	 */
	harmfactorTest_completeRetest,
	
	/**
	 * 存在不符合项
	 * 影响：
	 * 职业病危害因素检测有不符合项，待整改
	 */
	harmfactorTest_hasNonConformity,
	
	
	/**
	 * 上报完成
	 * 影响：
	 * 职业病危害因素检测与评价结果待上报登记
	 */
	harmfactorTest_completeReport,
	
	/**
	 * 整改完成,来源是危害因素检测
	 * 影响：
	 * reformManagement_complete
	 * 职业病危害因素检测有不符合项，待整改
	 * 已有不符合项整改完成，待检测验证（1）
	 */
	reformManagement_completeSourceHarmFactor,
	
	/**
	 * 整改完成
	 * 影响：
	 * 
	 */
	reformManagement_complete,
	
	/**
	 * 事故完成
	 * 影响：
	 * 发生职业病危害事故，是否进行职业病危害现状评价？（1）
	 */
	accidentManement_complete,
	
	
	/**
	 * 三同时项目试运行。
	 * 影响：
	 * 【XX】项目进入试运行阶段，是否进行职业病危害控制效果评价？
	 * 
	 */
	threeSimultaneityManagement_projectRun,
	
	/**
	 * 职业健康体检存草稿
	 * 影响：
	 * 请点击【新增】开始一项新的职业健康检查工作
	 * 进行中的职业健康检查工作（1）
	 */
	healthCheck_draff,
	
	/**
	 * 职业健康体检完成
	 * 影响：
	 * 请点击【新增】开始一项新的职业健康检查工作
	 * 进行中的职业健康检查工作（1）
	 */
	healthCheck_complete,
	
	/**
	 * 职业健康体检删除
	 * 影响：
	 * 请点击【新增】开始一项新的职业健康检查工作
	 * 进行中的职业健康检查工作（1）
	 */
	healthCheck_delete,
	
	/**
	 * 体检结果有异常（复查、职业禁忌证、疑似职业病人）
	 * 影响：
	 * 体检结果有异常人员，待处理（11）
	 */
	healthCheck_resultHasAbnormal,
		
	;
	
		

}
