package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum StatusEnum {

	
	/**
	 * 作废
	 */
	toVoid("作废", (byte) -2),
	
	/**
	 * 关键工作提醒的默认值
	 */
	none("无", (byte) -1),

	/**
	 * 存草稿、可编辑
	 */
	draff("可编辑", (byte) 0),
	/**
	 * 审批中
	 */
	approving("审批中", (byte) 1),
	/**
	 * 审批失败
	 */
	approveFail("审批失败", (byte) 2),

	/**
	 * 完成（阶段完成，不可修改）
	 */
	complete("完成", (byte) 3),

	/**
	 * 审批通过
	 */
	approveSuccess("审批成功", (byte) 4),

	/**
	 * 整个流程完成，不仅仅只主表信息不可修改，包括子表信息均不可修改。
	 */
	finished("结束", (byte) 5),

	/**
	 * 忽略
	 */
	ignore("忽略", (byte) 6),
	
	/**
	 * 整改相关信息完成
	 */
	reformAboutComplete("整改相关信息完成",(byte)7),
	
	sended("已发送",(byte)8),

	;

	/**
	 * 是否需要做数据验证
	 * 
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-上午11:32:03
	 * @param status
	 * @return
	 */
	public static boolean isNeedValidate(Byte status) {
		if (status == null) {
			return false;
		}
		if (StatusEnum.complete.getValue().equals(status)) {
			return true;
		} else if (StatusEnum.finished.getValue().equals(status)) {
			return true;
		}
		return false;
	}

	// 成员变量
	private String name;
	private Byte value;
	// 构造方法

	private StatusEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(StatusEnum type : StatusEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

}
