package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SimpleStatusEnum {

	
	/**
	 * 存草稿、可编辑
	 */
	draff("可编辑", (byte) 0),
	/**
	 * 已完成
	 */
	complete("已完成", (byte) 1),	
	
	/**
	 * 已作废
	 */
	canceled("已作废", (byte) 2),

	;

	
	// 成员变量
	private String name;
	private Byte value;
	// 构造方法

	private SimpleStatusEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(SimpleStatusEnum type : SimpleStatusEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

}
