package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;


/**
 *工作变动提醒类型
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RemindWorkTypeEnum {



	GZZD("规章制度", (byte) 1),


	CZGC("操作规程", (byte) 2),


	YJYA("应急预案", (byte) 3),

	OTHER("其他", (byte) 4),

	ZYBWHYSJC("职业病危害因素检测", (byte) 5),

	ZYJKJC("职业健康检查", (byte) 6),


	;


	// 成员变量
	private String name;
	private Byte value;
	// 构造方法

	private RemindWorkTypeEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(RemindWorkTypeEnum type : RemindWorkTypeEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

}
