package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PermissionTypeEnum {

	/**
	 * 编辑
	 */
	edit("编辑", (byte) 1,"edit"),
	/**
	 * 查看
	 */
	view("查看", (byte) 2,"view"),
	/**
	 *删除
	 */
	del("删除", (byte) 3,"del"),
	/**
	 * 导出
	 */
	export("导出", (byte) 3,"export")
	;

	
	// 成员变量
	public String name;
	public Byte value;
	public String code;
	// 构造方法

	private PermissionTypeEnum(String name, Byte value,String code) {
		this.name = name;
		this.value = value;
		this.code=code;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(ActionEnum type : ActionEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	
}
