package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PermissionDetailAreaEnum {
	/**
	 * 100到199为基础权限
	 * 200到299为关键工作权限
	 * 300到399档案权限
	 * 400到499工作汇总权限
	 * 500到599系统权限
	 * 600到699统计查询权限
	 * */
	/**
	 * 100到199为基础权限
	 */
	base(100l,199l),
	/**
	 * 200到299为关键工作权限
	 */
	work(200l,299l),
	/**
	 *300到399档案权限
	 */
	doc(300l,399l),
	/**
	 * 400到499工作汇总权限
	 */
	workSummary(400l,499l),
	/**
	 *500到599系统权限
	 */
	sys(500l,599l),
	/**
	 * 600到699统计查询权限
	 */
	count(600l,699l)
	;

	
	// 成员变量
	public Long min;
	public Long max;
	// 构造方法

	private PermissionDetailAreaEnum(Long min, Long max) {
		this.min = min;
		this.max = max;
	}

	public Long getMin() {
		return min;
	}

	public void setMin(Long min) {
		this.min = min;
	}

	public Long getMax() {
		return max;
	}

	public void setMax(Long max) {
		this.max = max;
	}	
	
}
