package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum NumberEnum {
	
	one(1,"一"),
	
	two(2,"两"),
	
	three(3,"三"),
	
	four(4,"四"),
	
	five(5,"五"),
	
	six(6,"六"),
	
	seven(7,"七"),
	
	eight(8,"八"),
	
	nine(9,"九"),
	
	ten(10,"十"),
	
	eleven(11,"十一"),
	
	twelve(12,"十二"),
	;

	
	// 成员变量
	private int value;
	private String code;
	// 构造方法

	private NumberEnum(int value,String code) {
		this.value = value;
		this.code=code;
	}
	
	public static String getCodeByValue(int value){
		
		for(NumberEnum type : NumberEnum.values()){
			if(type.getValue()==value){
				return type.getCode();
			}
		}
		return "";
	}

	

	/**
	 * @return the value
	 */
	public int getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(int value) {
		this.value = value;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

}
