package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MessageTypeEnum {

	/**
	 * 提醒
	 */
	remind("提醒",(byte)1,"remind"),
	
	/**
	 * 工作消息
	 */
	work("工作消息",(byte)2,"work"),
	
	/**
	 * 通知公告
	 */
	notice("通知",(byte)3,"notice"),
	
	/**
	 * 法律法规消息
	 */
	lawAndRegulations("法律法规消息",(byte)4,"lawAndRegulations"),
	
	/**
	 * 系统消息
	 */
	syatem("系统消息",(byte)5,"syatem"),
	; 
	
	// 成员变量
	private String name;
	private Byte value;
	private String code;
	// 构造方法

	private MessageTypeEnum(String name, Byte value,String code) {
		this.name = name;
		this.value = value;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte value) {
		if (value == null) {
			return null;
		}
		for (MessageTypeEnum c : MessageTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getCode(Byte value) {
		if (value == null) {
			return null;
		}
		for (MessageTypeEnum c : MessageTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte index) {
		this.value = index;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	
}
