package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MessageStateEnum {

    unRead("未读", (byte) 0),
    readed("已读", (byte) 1),
    delayed("延时", (byte) 2),
    delete("删除", (byte) 3),
    ignore("忽略", (byte) 4),
    ;

    private String name;
    private Byte value;

    private MessageStateEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (MessageStateEnum c : MessageStateEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getValue() {
        return value;
    }

    public void setValue(Byte index) {
        this.value = index;
    }
}
