package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 消息来源枚举，如果没有，请自行添加枚举项，并修改SysMessage类中messageSource验证的最大值（max）。
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年7月8日-上午11:49:50
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MessageSourceEnum {

	/**
	 * 年度计划
	 */
	yearPlan("年度计划",(byte)1,"yearPlan"),
	
	
	; 
	
	// 成员变量
	private String name;
	private Byte value;
	private String code;
	// 构造方法

	private MessageSourceEnum(String name, Byte value,String code) {
		this.name = name;
		this.value = value;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte value) {
		if (value == null) {
			return null;
		}
		for (MessageSourceEnum c : MessageSourceEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getCode(Byte value) {
		if (value == null) {
			return null;
		}
		for (MessageSourceEnum c : MessageSourceEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte index) {
		this.value = index;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	
}
