package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MessageBusinessTypeEnum {

    /**
     * 提醒（101、评价工作管理 102、隐患排查 103、工作计划）
     */
    remind("提醒", (byte) 1, "remind"),
    /**
     * 工作消息
     */
    work("工作消息", (byte) 2, "work"),
    /**
     * 通知公告
     */
    notice("通知公告", (byte) 3, "notice"),
    /**
     * 法律法规消息
     */
    law("法律法规消息", (byte) 4, "law"),
    /**
     * 系统消息
     */
    system("系统消息", (byte) 5, "system"),
    /**
     * 在线培训消息
     */
    onlineTrain("在线培训消息", (byte) 6, "onlineTrain"),
    ;

    private String name;
    private Byte value;
    private String code;

    private MessageBusinessTypeEnum(String name, Byte value, String code) {
        this.name = name;
        this.value = value;
        this.code = code;
    }

    public static String getName(Byte value) {
        if (value == null) {
            return null;
        }
        for (MessageBusinessTypeEnum c : MessageBusinessTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static String getCode(Byte value) {
        if (value == null) {
            return null;
        }
        for (MessageBusinessTypeEnum c : MessageBusinessTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getCode();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getValue() {
        return value;
    }

    public void setValue(Byte index) {
        this.value = index;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}